/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.model;

import org.springframework.shell.test.jediterm.terminal.TextStyle;

public class StyleState {
    private TextStyle myCurrentStyle = TextStyle.EMPTY;
    private TextStyle myDefaultStyle = TextStyle.EMPTY;
    private TextStyle myMergedStyle = null;

    public TextStyle getCurrent() {
        return TextStyle.getCanonicalStyle(this.getMergedStyle());
    }

    private static TextStyle merge(TextStyle style, TextStyle defaultStyle) {
        TextStyle.Builder builder = style.toBuilder();
        return builder.build();
    }

    public void reset() {
        this.myCurrentStyle = this.myDefaultStyle;
        this.myMergedStyle = null;
    }

    public void set(StyleState styleState) {
        this.setCurrent(styleState.getCurrent());
    }

    public void setDefaultStyle(TextStyle defaultStyle) {
        this.myDefaultStyle = defaultStyle;
        this.myMergedStyle = null;
    }

    public void setCurrent(TextStyle current) {
        this.myCurrentStyle = current;
        this.myMergedStyle = null;
    }

    private TextStyle getMergedStyle() {
        if (this.myMergedStyle == null) {
            this.myMergedStyle = StyleState.merge(this.myCurrentStyle, this.myDefaultStyle);
        }
        return this.myMergedStyle;
    }
}

