/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.emulator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.shell.test.jediterm.terminal.TerminalDataStream;
import org.springframework.shell.test.jediterm.terminal.util.CharUtils;

final class SystemCommandSequence {
    private static final char ST = '\u009c';
    private final List<Object> myArgs = new ArrayList<Object>();
    private final StringBuilder mySequence = new StringBuilder();

    public SystemCommandSequence(TerminalDataStream stream) throws IOException {
        StringBuilder argBuilder = new StringBuilder();
        boolean end = false;
        while (!end) {
            char ch = stream.getChar();
            this.mySequence.append(ch);
            end = this.isEnd();
            if (ch == ';' || end) {
                if (end && this.isTwoBytesEnd()) {
                    argBuilder.deleteCharAt(argBuilder.length() - 1);
                }
                this.myArgs.add(this.parseArg(argBuilder.toString()));
                argBuilder.setLength(0);
                continue;
            }
            argBuilder.append(ch);
        }
    }

    private Object parseArg(String arg) {
        if (arg.length() > 0 && Character.isDigit(arg.charAt(arg.length() - 1))) {
            try {
                return Integer.parseInt(arg);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arg;
    }

    private boolean isEnd() {
        int len = this.mySequence.length();
        if (len > 0) {
            char ch = this.mySequence.charAt(len - 1);
            return ch == '\u0007' || ch == '\u009c' || this.isTwoBytesEnd();
        }
        return false;
    }

    private boolean isTwoBytesEnd() {
        int len = this.mySequence.length();
        return len > 1 && this.mySequence.charAt(len - 2) == '\u001b' && this.mySequence.charAt(len - 1) == '\\';
    }

    public String getStringAt(int i) {
        if (i >= this.myArgs.size()) {
            return null;
        }
        Object val = this.myArgs.get(i);
        return val instanceof String ? (String)val : null;
    }

    public int getIntAt(int position, int defaultValue) {
        Object val;
        if (position < this.myArgs.size() && (val = this.myArgs.get(position)) instanceof Integer) {
            return (Integer)val;
        }
        return defaultValue;
    }

    public String format(String body) {
        return "\u001b]" + body + this.getTerminator();
    }

    public String toString() {
        return CharUtils.toHumanReadableText(this.mySequence.toString());
    }

    private String getTerminator() {
        int len = this.mySequence.length();
        if (this.isTwoBytesEnd()) {
            return this.mySequence.substring(len - 2);
        }
        return this.mySequence.substring(len - 1);
    }
}

