/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.shell.Availability;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.MethodTargetRegistrar;
import org.springframework.shell.Utils;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.command.CommandExceptionResolver;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.annotation.MethodCommandExceptionResolver;
import org.springframework.shell.completion.CompletionResolver;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;
import org.springframework.shell.standard.ValueProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class StandardMethodTargetRegistrar
implements MethodTargetRegistrar {
    private final Logger log = LoggerFactory.getLogger(StandardMethodTargetRegistrar.class);
    private ApplicationContext applicationContext;
    private CommandRegistration.BuilderSupplier commandRegistrationBuilderSupplier;

    public StandardMethodTargetRegistrar(ApplicationContext applicationContext, CommandRegistration.BuilderSupplier commandRegistrationBuilderSupplier) {
        this.applicationContext = applicationContext;
        this.commandRegistrationBuilderSupplier = commandRegistrationBuilderSupplier;
    }

    public void register(CommandCatalog registry) {
        Map commandBeans = this.applicationContext.getBeansWithAnnotation(ShellComponent.class);
        this.log.debug("Found commandBeans to register {}", (Object)commandBeans);
        for (Object bean : commandBeans.values()) {
            Class<?> clazz = bean.getClass();
            ReflectionUtils.doWithMethods(clazz, method -> {
                ShellMethod shellMapping = method.getAnnotation(ShellMethod.class);
                String[] keys = shellMapping.key();
                if (keys.length == 0) {
                    keys = new String[]{Utils.unCamelify((CharSequence)method.getName())};
                }
                String group = this.getOrInferGroup(method);
                String key = keys[0];
                this.log.debug("Registering with keys='{}' key='{}'", (Object)keys, (Object)key);
                Supplier<Availability> availabilityIndicator = this.findAvailabilityIndicator(keys, bean, method);
                CommandRegistration.Builder builder = ((CommandRegistration.Builder)this.commandRegistrationBuilderSupplier.get()).command(new String[]{key}).group(group).description(shellMapping.value()).interactionMode(shellMapping.interactionMode()).availability(availabilityIndicator);
                for (int i = 1; i < keys.length; ++i) {
                    builder.withAlias().command(new String[]{keys[i]}).group(group);
                }
                InvocableHandlerMethod ihm = new InvocableHandlerMethod(bean, method);
                for (MethodParameter mp : ihm.getMethodParameters()) {
                    ShellOption so = (ShellOption)mp.getParameterAnnotation(ShellOption.class);
                    this.log.debug("Registering with mp='{}' so='{}'", (Object)mp, (Object)so);
                    if (so != null) {
                        ArrayList<String> longNames = new ArrayList<String>();
                        ArrayList shortNames = new ArrayList();
                        if (!ObjectUtils.isEmpty((Object[])so.value())) {
                            Arrays.asList(so.value()).stream().forEach(o -> {
                                String stripped = StringUtils.trimLeadingCharacter((String)o, (char)'-');
                                this.log.debug("Registering o='{}' stripped='{}'", o, (Object)stripped);
                                if (o.length() == stripped.length() + 2) {
                                    longNames.add(stripped);
                                } else if (o.length() == stripped.length() + 1 && stripped.length() == 1) {
                                    shortNames.add(Character.valueOf(stripped.charAt(0)));
                                } else if (o.length() == stripped.length()) {
                                    if ("--".equals(shellMapping.prefix())) {
                                        longNames.add(stripped);
                                    } else if ("-".equals(shellMapping.prefix()) && stripped.length() == 1) {
                                        shortNames.add(Character.valueOf(stripped.charAt(0)));
                                    }
                                }
                            });
                        } else {
                            mp.initParameterNameDiscovery((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
                            String longName = mp.getParameterName();
                            Class parameterType = mp.getParameterType();
                            if (longName != null) {
                                this.log.debug("Using mp='{}' longName='{}' parameterType='{}'", new Object[]{mp, longName, parameterType});
                                longNames.add(longName);
                            }
                        }
                        if (longNames.isEmpty() && shortNames.isEmpty()) continue;
                        this.log.debug("Registering longNames='{}' shortNames='{}'", longNames, shortNames);
                        Class parameterType = mp.getParameterType();
                        Type genericParameterType = mp.getGenericParameterType();
                        CommandRegistration.OptionSpec optionSpec = builder.withOption().type(genericParameterType).longNames(longNames.toArray(new String[0])).shortNames(shortNames.toArray(new Character[0])).position(Integer.valueOf(mp.getParameterIndex())).description(so.help());
                        if (so.arity() > -1) {
                            optionSpec.arity(0, so.arity());
                        } else if (ClassUtils.isAssignable(Boolean.TYPE, (Class)parameterType)) {
                            optionSpec.arity(CommandRegistration.OptionArity.ZERO_OR_ONE);
                        } else if (ClassUtils.isAssignable(Boolean.class, (Class)parameterType)) {
                            optionSpec.arity(CommandRegistration.OptionArity.ZERO_OR_ONE);
                        }
                        if (!ObjectUtils.nullSafeEquals((Object)so.defaultValue(), (Object)"__NONE__") && !ObjectUtils.nullSafeEquals((Object)so.defaultValue(), (Object)"__NULL__")) {
                            optionSpec.defaultValue(so.defaultValue());
                        }
                        if (ObjectUtils.nullSafeEquals((Object)so.defaultValue(), (Object)"__NONE__")) {
                            if (ClassUtils.isAssignable(Boolean.TYPE, (Class)parameterType)) {
                                optionSpec.required(false);
                                optionSpec.defaultValue("false");
                            } else {
                                optionSpec.required();
                            }
                        }
                        if (ClassUtils.isAssignable(ShellOption.NoValueProvider.class, so.valueProvider())) continue;
                        CompletionResolver completionResolver = ctx -> {
                            ValueProvider valueProviderBean = (ValueProvider)this.applicationContext.getBean(so.valueProvider());
                            List<CompletionProposal> complete = valueProviderBean.complete((CompletionContext)ctx);
                            return complete;
                        };
                        optionSpec.completion(completionResolver);
                        continue;
                    }
                    mp.initParameterNameDiscovery((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
                    String longName = mp.getParameterName();
                    Class parameterType = mp.getParameterType();
                    if (longName == null) continue;
                    this.log.debug("Using mp='{}' longName='{}' parameterType='{}'", new Object[]{mp, longName, parameterType});
                    CommandRegistration.OptionSpec optionSpec = builder.withOption().longNames(new String[]{longName}).type((Type)parameterType).required().position(Integer.valueOf(mp.getParameterIndex()));
                    if (ClassUtils.isAssignable(Boolean.TYPE, (Class)parameterType)) {
                        optionSpec.arity(CommandRegistration.OptionArity.ZERO_OR_ONE);
                        optionSpec.required(false);
                        optionSpec.defaultValue("false");
                        continue;
                    }
                    if (ClassUtils.isAssignable(Boolean.class, (Class)parameterType)) {
                        optionSpec.arity(CommandRegistration.OptionArity.ZERO_OR_ONE);
                        continue;
                    }
                    optionSpec.arity(CommandRegistration.OptionArity.EXACTLY_ONE);
                }
                builder.withTarget().method(bean, method);
                ObjectProvider terminal = this.applicationContext.getBeanProvider(Terminal.class);
                MethodCommandExceptionResolver resolver = new MethodCommandExceptionResolver(bean, (Terminal)terminal.getIfAvailable(() -> null));
                builder.withErrorHandling().resolver((CommandExceptionResolver)resolver);
                CommandRegistration registration = builder.build();
                registry.register(new CommandRegistration[]{registration});
            }, method -> method.getAnnotation(ShellMethod.class) != null);
        }
    }

    private String getOrInferGroup(Method method) {
        ShellMethod methodAnn = (ShellMethod)AnnotationUtils.getAnnotation((Method)method, ShellMethod.class);
        if (!methodAnn.group().equals("")) {
            return methodAnn.group();
        }
        Class<?> clazz = method.getDeclaringClass();
        ShellCommandGroup classAnn = (ShellCommandGroup)AnnotationUtils.getAnnotation(clazz, ShellCommandGroup.class);
        if (classAnn != null && !classAnn.value().equals("")) {
            return classAnn.value();
        }
        ShellCommandGroup packageAnn = (ShellCommandGroup)AnnotationUtils.getAnnotation((AnnotatedElement)clazz.getPackage(), ShellCommandGroup.class);
        if (packageAnn != null && !packageAnn.value().equals("")) {
            return packageAnn.value();
        }
        return StringUtils.arrayToDelimitedString((Object[])clazz.getSimpleName().split("(?<=[a-z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][a-z])"), (String)" ");
    }

    private Supplier<Availability> findAvailabilityIndicator(String[] commandKeys, Object bean, Method method) {
        Method indicator;
        ShellMethodAvailability explicit = method.getAnnotation(ShellMethodAvailability.class);
        if (explicit != null) {
            Assert.isTrue((explicit.value().length == 1 ? 1 : 0) != 0, (String)("When set on a @" + ShellMethod.class.getSimpleName() + " method, the value of the @" + ShellMethodAvailability.class.getSimpleName() + " should be a single element, the name of a method that returns " + Availability.class.getSimpleName() + ". Found " + Arrays.asList(explicit.value()) + " for " + method));
            indicator = ReflectionUtils.findMethod(bean.getClass(), (String)explicit.value()[0]);
        } else {
            Method implicit = ReflectionUtils.findMethod(bean.getClass(), (String)(method.getName() + "Availability"));
            if (implicit != null) {
                indicator = implicit;
            } else {
                HashMap candidates = new HashMap();
                ReflectionUtils.doWithMethods(bean.getClass(), candidate -> {
                    ArrayList<String> matchKeys = new ArrayList<String>(Arrays.asList(candidate.getAnnotation(ShellMethodAvailability.class).value()));
                    if (matchKeys.contains("*")) {
                        Assert.isTrue((matchKeys.size() == 1 ? 1 : 0) != 0, (String)("When using '*' as a wildcard for " + ShellMethodAvailability.class.getSimpleName() + ", this can be the only value. Found " + matchKeys + " on method " + candidate));
                        candidates.put(candidate, matchKeys);
                    } else {
                        matchKeys.retainAll(Arrays.asList(commandKeys));
                        if (!matchKeys.isEmpty()) {
                            candidates.put(candidate, matchKeys);
                        }
                    }
                }, m -> m.getAnnotation(ShellMethodAvailability.class) != null && m.getAnnotation(ShellMethod.class) == null);
                Set notUsingWildcard = candidates.entrySet().stream().filter(e -> !((Collection)e.getValue()).contains("*")).map(Map.Entry::getKey).collect(Collectors.toSet());
                Assert.isTrue((notUsingWildcard.size() <= 1 ? 1 : 0) != 0, (String)("Found several @" + ShellMethodAvailability.class.getSimpleName() + " annotated methods that could apply for " + method + ". Offending candidates are " + notUsingWildcard));
                indicator = notUsingWildcard.size() == 1 ? (Method)notUsingWildcard.iterator().next() : (candidates.size() == 1 ? (Method)candidates.keySet().iterator().next() : null);
            }
        }
        if (indicator != null) {
            Assert.isTrue((boolean)indicator.getReturnType().equals(Availability.class), (String)("Method " + indicator + " should return " + Availability.class.getSimpleName()));
            Assert.isTrue((indicator.getParameterCount() == 0 ? 1 : 0) != 0, (String)("Method " + indicator + " should be a no-arg method"));
            ReflectionUtils.makeAccessible((Method)indicator);
            return () -> (Availability)ReflectionUtils.invokeMethod((Method)indicator, (Object)bean);
        }
        return null;
    }
}

