/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.shell.Availability;
import org.springframework.shell.Command;
import org.springframework.shell.ConfigurableCommandRegistry;
import org.springframework.shell.MethodTarget;
import org.springframework.shell.MethodTargetRegistrar;
import org.springframework.shell.Utils;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class StandardMethodTargetRegistrar
implements MethodTargetRegistrar {
    private ApplicationContext applicationContext;
    private Map<String, MethodTarget> commands = new HashMap<String, MethodTarget>();

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void register(ConfigurableCommandRegistry registry) {
        Map commandBeans = this.applicationContext.getBeansWithAnnotation(ShellComponent.class);
        for (Object bean : commandBeans.values()) {
            Class<?> clazz = bean.getClass();
            ReflectionUtils.doWithMethods(clazz, method -> {
                ShellMethod shellMapping = method.getAnnotation(ShellMethod.class);
                String[] keys = shellMapping.key();
                if (keys.length == 0) {
                    keys = new String[]{Utils.unCamelify((CharSequence)method.getName())};
                }
                String group = this.getOrInferGroup(method);
                for (String key : keys) {
                    Supplier<Availability> availabilityIndicator = this.findAvailabilityIndicator(keys, bean, method);
                    MethodTarget target = new MethodTarget(method, bean, new Command.Help(shellMapping.value(), group), availabilityIndicator);
                    registry.register(key, target);
                    this.commands.put(key, target);
                }
            }, method -> method.getAnnotation(ShellMethod.class) != null);
        }
    }

    private String getOrInferGroup(Method method) {
        ShellMethod methodAnn = (ShellMethod)AnnotationUtils.getAnnotation((Method)method, ShellMethod.class);
        if (!methodAnn.group().equals("")) {
            return methodAnn.group();
        }
        Class<?> clazz = method.getDeclaringClass();
        ShellCommandGroup classAnn = (ShellCommandGroup)AnnotationUtils.getAnnotation(clazz, ShellCommandGroup.class);
        if (classAnn != null && !classAnn.value().equals("")) {
            return classAnn.value();
        }
        ShellCommandGroup packageAnn = (ShellCommandGroup)AnnotationUtils.getAnnotation((AnnotatedElement)clazz.getPackage(), ShellCommandGroup.class);
        if (packageAnn != null && !packageAnn.value().equals("")) {
            return packageAnn.value();
        }
        return StringUtils.arrayToDelimitedString((Object[])clazz.getSimpleName().split("(?<=[a-z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][a-z])"), (String)" ");
    }

    private Supplier<Availability> findAvailabilityIndicator(String[] commandKeys, Object bean, Method method) {
        Method indicator;
        ShellMethodAvailability explicit = method.getAnnotation(ShellMethodAvailability.class);
        if (explicit != null) {
            Assert.isTrue((explicit.value().length == 1 ? 1 : 0) != 0, (String)("When set on a @" + ShellMethod.class.getSimpleName() + " method, the value of the @" + ShellMethodAvailability.class.getSimpleName() + " should be a single element, the name of a method that returns " + Availability.class.getSimpleName() + ". Found " + Arrays.asList(explicit.value()) + " for " + method));
            indicator = ReflectionUtils.findMethod(bean.getClass(), (String)explicit.value()[0]);
        } else {
            Method implicit = ReflectionUtils.findMethod(bean.getClass(), (String)(method.getName() + "Availability"));
            if (implicit != null) {
                indicator = implicit;
            } else {
                HashMap candidates = new HashMap();
                ReflectionUtils.doWithMethods(bean.getClass(), candidate -> {
                    ArrayList<String> matchKeys = new ArrayList<String>(Arrays.asList(candidate.getAnnotation(ShellMethodAvailability.class).value()));
                    if (matchKeys.contains("*")) {
                        Assert.isTrue((matchKeys.size() == 1 ? 1 : 0) != 0, (String)("When using '*' as a wildcard for " + ShellMethodAvailability.class.getSimpleName() + ", this can be the only value. Found " + matchKeys + " on method " + candidate));
                        candidates.put(candidate, matchKeys);
                    } else {
                        matchKeys.retainAll(Arrays.asList(commandKeys));
                        if (!matchKeys.isEmpty()) {
                            candidates.put(candidate, matchKeys);
                        }
                    }
                }, m -> m.getAnnotation(ShellMethodAvailability.class) != null && m.getAnnotation(ShellMethod.class) == null);
                Set notUsingWildcard = candidates.entrySet().stream().filter(e -> !((Collection)e.getValue()).contains("*")).map(Map.Entry::getKey).collect(Collectors.toSet());
                Assert.isTrue((notUsingWildcard.size() <= 1 ? 1 : 0) != 0, (String)("Found several @" + ShellMethodAvailability.class.getSimpleName() + " annotated methods that could apply for " + method + ". Offending candidates are " + notUsingWildcard));
                indicator = notUsingWildcard.size() == 1 ? (Method)notUsingWildcard.iterator().next() : (candidates.size() == 1 ? (Method)candidates.keySet().iterator().next() : null);
            }
        }
        if (indicator != null) {
            Assert.isTrue((boolean)indicator.getReturnType().equals(Availability.class), (String)("Method " + indicator + " should return " + Availability.class.getSimpleName()));
            Assert.isTrue((indicator.getParameterCount() == 0 ? 1 : 0) != 0, (String)("Method " + indicator + " should be a no-arg method"));
            ReflectionUtils.makeAccessible((Method)indicator);
            return () -> (Availability)ReflectionUtils.invokeMethod((Method)indicator, (Object)bean);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " contributing " + StringUtils.collectionToDelimitedString(this.commands.keySet(), (String)", ", (String)"[", (String)"]");
    }
}

