/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.mongodb.DBObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.MongoExpiringSession;
import org.springframework.session.data.mongo.SessionConverterProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoOperationsSessionRepository
implements FindByIndexNameSessionRepository<MongoExpiringSession> {
    public static final int DEFAULT_INACTIVE_INTERVAL = 1800;
    public static final String DEFAULT_COLLECTION_NAME = "sessions";
    private final MongoOperations mongoOperations;
    private AbstractMongoSessionConverter mongoSessionConverter = SessionConverterProvider.getDefaultMongoConverter();
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String collectionName = "sessions";

    public MongoOperationsSessionRepository(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    @Override
    public MongoExpiringSession createSession() {
        MongoExpiringSession session = new MongoExpiringSession();
        if (this.maxInactiveIntervalInSeconds != null) {
            session.setMaxInactiveIntervalInSeconds(this.maxInactiveIntervalInSeconds);
        }
        return session;
    }

    @Override
    public void save(MongoExpiringSession session) {
        DBObject sessionDbObject = this.convertToDBObject(session);
        this.mongoOperations.getCollection(this.collectionName).save(sessionDbObject);
    }

    @Override
    public MongoExpiringSession getSession(String id) {
        DBObject sessionWrapper = this.findSession(id);
        if (sessionWrapper == null) {
            return null;
        }
        MongoExpiringSession session = this.convertToSession(sessionWrapper);
        if (session.isExpired()) {
            this.delete(id);
            return null;
        }
        return session;
    }

    @Override
    public Map<String, MongoExpiringSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        HashMap<String, MongoExpiringSession> result = new HashMap<String, MongoExpiringSession>();
        Query query = this.mongoSessionConverter.getQueryForIndex(indexName, indexValue);
        if (query == null) {
            return Collections.emptyMap();
        }
        List mapSessions = this.mongoOperations.find(query, DBObject.class, this.collectionName);
        for (DBObject dbSession : mapSessions) {
            MongoExpiringSession mapSession = this.convertToSession(dbSession);
            result.put(mapSession.getId(), mapSession);
        }
        return result;
    }

    @Override
    public void delete(String id) {
        this.mongoOperations.remove((Object)this.findSession(id), this.collectionName);
    }

    @PostConstruct
    public void ensureIndexesAreCreated() {
        IndexOperations indexOperations = this.mongoOperations.indexOps(this.collectionName);
        this.mongoSessionConverter.ensureIndexes(indexOperations);
    }

    DBObject findSession(String id) {
        return (DBObject)this.mongoOperations.findById((Object)id, DBObject.class, this.collectionName);
    }

    MongoExpiringSession convertToSession(DBObject session) {
        return (MongoExpiringSession)this.mongoSessionConverter.convert(session, TypeDescriptor.valueOf(DBObject.class), TypeDescriptor.valueOf(MongoExpiringSession.class));
    }

    DBObject convertToDBObject(MongoExpiringSession session) {
        return (DBObject)this.mongoSessionConverter.convert(session, TypeDescriptor.valueOf(MongoExpiringSession.class), TypeDescriptor.valueOf(DBObject.class));
    }

    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }
}

