/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.userinfo;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import java.util.HashSet;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class DefaultReactiveOAuth2UserService
implements ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> {
    private static final String INVALID_USER_INFO_RESPONSE_ERROR_CODE = "invalid_user_info_response";
    private static final String MISSING_USER_INFO_URI_ERROR_CODE = "missing_user_info_uri";
    private static final String MISSING_USER_NAME_ATTRIBUTE_ERROR_CODE = "missing_user_name_attribute";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final ParameterizedTypeReference<Map<String, String>> STRING_STRING_MAP = new ParameterizedTypeReference<Map<String, String>>(){};
    private Converter<OAuth2UserRequest, Converter<Map<String, Object>, Map<String, Object>>> attributesConverter = request -> attributes -> attributes;
    private WebClient webClient = WebClient.create();

    @Override
    public Mono<OAuth2User> loadUser(OAuth2UserRequest userRequest) throws OAuth2AuthenticationException {
        return Mono.defer(() -> {
            Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
            String userInfoUri = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUri();
            if (!StringUtils.hasText((String)userInfoUri)) {
                OAuth2Error oauth2Error = new OAuth2Error(MISSING_USER_INFO_URI_ERROR_CODE, "Missing required UserInfo Uri in UserInfoEndpoint for Client Registration: " + userRequest.getClientRegistration().getRegistrationId(), null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
            if (!StringUtils.hasText((String)userNameAttributeName)) {
                OAuth2Error oauth2Error = new OAuth2Error(MISSING_USER_NAME_ATTRIBUTE_ERROR_CODE, "Missing required \"user name\" attribute name in UserInfoEndpoint for Client Registration: " + userRequest.getClientRegistration().getRegistrationId(), null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            AuthenticationMethod authenticationMethod = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getAuthenticationMethod();
            WebClient.RequestHeadersSpec<?> requestHeadersSpec = this.getRequestHeaderSpec(userRequest, userInfoUri, authenticationMethod);
            Mono userAttributes = requestHeadersSpec.retrieve().onStatus(HttpStatusCode::isError, response -> DefaultReactiveOAuth2UserService.parse(response).map(userInfoErrorResponse -> {
                String description = userInfoErrorResponse.getErrorObject().getDescription();
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE, description, null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            })).bodyToMono(STRING_OBJECT_MAP).mapNotNull(attributes -> (Map)((Converter)this.attributesConverter.convert((Object)userRequest)).convert(attributes));
            return userAttributes.map(attrs -> {
                OAuth2UserAuthority authority = new OAuth2UserAuthority(attrs);
                HashSet<Object> authorities = new HashSet<Object>();
                authorities.add(authority);
                OAuth2AccessToken token = userRequest.getAccessToken();
                for (String scope : token.getScopes()) {
                    authorities.add(new SimpleGrantedAuthority("SCOPE_" + scope));
                }
                return new DefaultOAuth2User(authorities, attrs, userNameAttributeName);
            }).onErrorMap(ex -> ex instanceof UnsupportedMediaTypeException || ex.getCause() instanceof UnsupportedMediaTypeException, ex -> {
                String contentType = ex instanceof UnsupportedMediaTypeException ? ((UnsupportedMediaTypeException)ex).getContentType().toString() : ((UnsupportedMediaTypeException)ex.getCause()).getContentType().toString();
                String errorMessage = "An error occurred while attempting to retrieve the UserInfo Resource from '" + userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUri() + "': response contains invalid content type '" + contentType + "'. The UserInfo Response should return a JSON object (content type 'application/json') that contains a collection of name and value pairs of the claims about the authenticated End-User. Please ensure the UserInfo Uri in UserInfoEndpoint for Client Registration '" + userRequest.getClientRegistration().getRegistrationId() + "' conforms to the UserInfo Endpoint, as defined in OpenID Connect 1.0: 'https://openid.net/specs/openid-connect-core-1_0.html#UserInfo'";
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE, errorMessage, null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString(), ex);
            }).onErrorMap(ex -> {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE, "An error occurred reading the UserInfo response: " + ex.getMessage(), null);
                return new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString(), ex);
            });
        });
    }

    private WebClient.RequestHeadersSpec<?> getRequestHeaderSpec(OAuth2UserRequest userRequest, String userInfoUri, AuthenticationMethod authenticationMethod) {
        if (AuthenticationMethod.FORM.equals((Object)authenticationMethod)) {
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(userInfoUri, new Object[0])).header("Accept", new String[]{"application/json"})).header("Content-Type", new String[]{"application/x-www-form-urlencoded"})).bodyValue((Object)("access_token=" + userRequest.getAccessToken().getTokenValue()));
        }
        return this.webClient.get().uri(userInfoUri, new Object[0]).header("Accept", new String[]{"application/json"}).headers(headers -> headers.setBearerAuth(userRequest.getAccessToken().getTokenValue()));
    }

    public void setAttributesConverter(Converter<OAuth2UserRequest, Converter<Map<String, Object>, Map<String, Object>>> attributesConverter) {
        Assert.notNull(attributesConverter, (String)"attributesConverter cannot be null");
        this.attributesConverter = attributesConverter;
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }

    private static Mono<UserInfoErrorResponse> parse(ClientResponse httpResponse) {
        String wwwAuth = httpResponse.headers().asHttpHeaders().getFirst("WWW-Authenticate");
        if (StringUtils.hasLength((String)wwwAuth)) {
            return Mono.fromCallable(() -> UserInfoErrorResponse.parse((String)wwwAuth));
        }
        return httpResponse.bodyToMono(STRING_STRING_MAP).map(body -> new UserInfoErrorResponse(ErrorObject.parse((JSONObject)new JSONObject(body))));
    }
}

