/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.webtestclient;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.DefaultPartHttpMessageReader;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.OperationRequestPartFactory;
import org.springframework.restdocs.operation.RequestConverter;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.util.LinkedMultiValueMap;
import reactor.core.publisher.Flux;

class WebTestClientRequestConverter
implements RequestConverter<ExchangeResult> {
    WebTestClientRequestConverter() {
    }

    public OperationRequest convert(ExchangeResult result) {
        HttpHeaders headers = this.extractRequestHeaders(result);
        return new OperationRequestFactory().create(result.getUrl(), result.getMethod(), result.getRequestBodyContent(), headers, this.extractRequestParts(result), this.extractCookies(headers));
    }

    private HttpHeaders extractRequestHeaders(ExchangeResult result) {
        HttpHeaders extracted = new HttpHeaders();
        extracted.putAll(result.getRequestHeaders());
        extracted.remove("WebTestClient-Request-Id");
        return extracted;
    }

    private @Nullable List<OperationRequestPart> extractRequestParts(ExchangeResult result) {
        DefaultPartHttpMessageReader partHttpMessageReader = new DefaultPartHttpMessageReader();
        return (List)new MultipartHttpMessageReader((HttpMessageReader)partHttpMessageReader).readMono(ResolvableType.forClass(Part.class), (ReactiveHttpInputMessage)new ExchangeResultReactiveHttpInputMessage(result), Collections.emptyMap()).onErrorReturn((Object)new LinkedMultiValueMap()).map(partsMap -> partsMap.values().stream().flatMap(parts -> parts.stream().map(this::createOperationRequestPart)).collect(Collectors.toList())).block();
    }

    private OperationRequestPart createOperationRequestPart(Part part) {
        ByteArrayOutputStream content = this.readPartBodyContent(part);
        return new OperationRequestPartFactory().create(part.name(), part instanceof FilePart ? ((FilePart)part).filename() : null, content.toByteArray(), part.headers());
    }

    private ByteArrayOutputStream readPartBodyContent(Part part) {
        ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
        DataBufferUtils.write((Publisher)part.content(), (OutputStream)contentStream).blockFirst();
        return contentStream;
    }

    private Collection<RequestCookie> extractCookies(HttpHeaders headers) {
        List cookieHeaders = headers.get("Cookie");
        if (cookieHeaders == null) {
            return Collections.emptyList();
        }
        headers.remove("Cookie");
        return cookieHeaders.stream().map(this::createRequestCookie).collect(Collectors.toList());
    }

    private RequestCookie createRequestCookie(String header) {
        String[] components = header.split("=");
        return new RequestCookie(components[0], components[1]);
    }

    private final class ExchangeResultReactiveHttpInputMessage
    implements ReactiveHttpInputMessage {
        private final ExchangeResult result;

        private ExchangeResultReactiveHttpInputMessage(ExchangeResult result) {
            this.result = result;
        }

        public HttpHeaders getHeaders() {
            return this.result.getRequestHeaders();
        }

        public Flux<DataBuffer> getBody() {
            byte[] requestBodyContent = this.result.getRequestBodyContent();
            if (requestBodyContent == null) {
                requestBodyContent = new byte[]{};
            }
            DefaultDataBuffer buffer = new DefaultDataBufferFactory().allocateBuffer(requestBodyContent.length);
            buffer.write(requestBodyContent);
            return Flux.fromArray((Object[])new DataBuffer[]{buffer});
        }
    }
}

