/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.restassured;

import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Response;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.ResponseConverter;

class RestAssuredResponseConverter
implements ResponseConverter<Response> {
    RestAssuredResponseConverter() {
    }

    public OperationResponse convert(Response response) {
        return new OperationResponseFactory().create(HttpStatus.valueOf((int)response.getStatusCode()), this.extractHeaders(response), this.extractContent(response));
    }

    private HttpHeaders extractHeaders(Response response) {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Header header : response.getHeaders()) {
            httpHeaders.add(header.getName(), header.getValue());
        }
        return httpHeaders;
    }

    private byte[] extractContent(Response response) {
        return response.getBody().asByteArray();
    }
}

