/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device;

import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DeviceType;

class LiteDevice
implements Device {
    public static final LiteDevice NORMAL_INSTANCE = new LiteDevice(DeviceType.NORMAL);
    public static final LiteDevice MOBILE_INSTANCE = new LiteDevice(DeviceType.MOBILE);
    public static final LiteDevice TABLET_INSTANCE = new LiteDevice(DeviceType.TABLET);
    private final DeviceType deviceType;

    public boolean isNormal() {
        return this.deviceType == DeviceType.NORMAL;
    }

    public boolean isMobile() {
        return this.deviceType == DeviceType.MOBILE;
    }

    public boolean isTablet() {
        return this.deviceType == DeviceType.TABLET;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[LiteDevice ");
        builder.append("type").append("=").append((Object)this.deviceType);
        builder.append("]");
        return builder.toString();
    }

    private LiteDevice(DeviceType deviceType) {
        this.deviceType = deviceType;
    }
}

