/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.switcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DeviceUtils;
import org.springframework.mobile.device.site.CookieSitePreferenceRepository;
import org.springframework.mobile.device.site.SitePreference;
import org.springframework.mobile.device.site.SitePreferenceHandler;
import org.springframework.mobile.device.site.StandardSitePreferenceHandler;
import org.springframework.mobile.device.switcher.MobileSitePathUrlFactory;
import org.springframework.mobile.device.switcher.NormalSitePathUrlFactory;
import org.springframework.mobile.device.switcher.SiteUrlFactory;
import org.springframework.mobile.device.switcher.StandardSiteUrlFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SiteSwitcherHandlerInterceptor
extends HandlerInterceptorAdapter {
    private final SiteUrlFactory normalSiteUrlFactory;
    private final SiteUrlFactory mobileSiteUrlFactory;
    private final SitePreferenceHandler sitePreferenceHandler;

    public SiteSwitcherHandlerInterceptor(SiteUrlFactory normalSiteUrlFactory, SiteUrlFactory mobileSiteUrlFactory, SitePreferenceHandler sitePreferenceHandler) {
        this.normalSiteUrlFactory = normalSiteUrlFactory;
        this.mobileSiteUrlFactory = mobileSiteUrlFactory;
        this.sitePreferenceHandler = sitePreferenceHandler;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SitePreference sitePreference = this.sitePreferenceHandler.handleSitePreference(request, response);
        if (this.mobileSiteUrlFactory.isRequestForSite(request)) {
            if (sitePreference == SitePreference.NORMAL) {
                response.sendRedirect(response.encodeRedirectURL(this.normalSiteUrlFactory.createSiteUrl(request)));
                return false;
            }
        } else {
            Device device = DeviceUtils.getRequiredCurrentDevice(request);
            if (sitePreference == SitePreference.MOBILE || device.isMobile() && sitePreference == null) {
                response.sendRedirect(response.encodeRedirectURL(this.mobileSiteUrlFactory.createSiteUrl(request)));
                return false;
            }
        }
        return true;
    }

    public static SiteSwitcherHandlerInterceptor mDot(String serverName) {
        return new SiteSwitcherHandlerInterceptor(new StandardSiteUrlFactory(serverName), new StandardSiteUrlFactory("m." + serverName), new StandardSitePreferenceHandler(new CookieSitePreferenceRepository("." + serverName)));
    }

    public static SiteSwitcherHandlerInterceptor dotMobi(String serverName) {
        int lastDot = serverName.lastIndexOf(46);
        return new SiteSwitcherHandlerInterceptor(new StandardSiteUrlFactory(serverName), new StandardSiteUrlFactory(serverName.substring(0, lastDot) + ".mobi"), new StandardSitePreferenceHandler(new CookieSitePreferenceRepository("." + serverName)));
    }

    public static SiteSwitcherHandlerInterceptor urlPath(String mobilePath) {
        return new SiteSwitcherHandlerInterceptor(new NormalSitePathUrlFactory(mobilePath), new MobileSitePathUrlFactory(mobilePath), new StandardSitePreferenceHandler(new CookieSitePreferenceRepository()));
    }

    public static SiteSwitcherHandlerInterceptor urlPath(String mobilePath, String rootPath) {
        return new SiteSwitcherHandlerInterceptor(new NormalSitePathUrlFactory(mobilePath, rootPath), new MobileSitePathUrlFactory(mobilePath, rootPath), new StandardSitePreferenceHandler(new CookieSitePreferenceRepository()));
    }
}

