/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.util.concurrent.TimeUnit;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.web.WebfluxTagConfigurer;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class MetricsWebFilter
implements WebFilter {
    private final MeterRegistry registry;
    private final WebfluxTagConfigurer tagConfigurer;
    private final String metricName;

    public MetricsWebFilter(MeterRegistry registry, WebfluxTagConfigurer tagConfigurer, String metricName) {
        this.registry = registry;
        this.tagConfigurer = tagConfigurer;
        this.metricName = metricName;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return chain.filter(exchange).compose(f -> {
            long start = System.nanoTime();
            return f.doOnSuccess(done -> this.registry.timer(this.metricName, this.tagConfigurer.httpRequestTags(exchange, null)).record(System.nanoTime() - start, TimeUnit.NANOSECONDS)).doOnError(t -> this.registry.timer(this.metricName, this.tagConfigurer.httpRequestTags(exchange, (Throwable)t)).record(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        });
    }
}

