/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.spectator;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.LongTaskTimer;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;

public class ExternalClockSpectatorRegistry
implements Registry {
    private final Registry composite;
    private final Clock clock;

    ExternalClockSpectatorRegistry(Registry registry, Clock clock) {
        this.composite = registry;
        this.clock = clock;
    }

    public Clock clock() {
        return this.clock;
    }

    public RegistryConfig config() {
        return this.composite.config();
    }

    public Id createId(String name) {
        return this.composite.createId(name);
    }

    public Id createId(String name, Iterable<Tag> tags) {
        return this.composite.createId(name, tags);
    }

    public void register(Meter meter) {
        this.composite.register(meter);
    }

    public ConcurrentMap<Id, Object> state() {
        return this.composite.state();
    }

    public Counter counter(Id id) {
        return this.composite.counter(id);
    }

    public DistributionSummary distributionSummary(Id id) {
        return this.composite.distributionSummary(id);
    }

    public Timer timer(Id id) {
        return this.composite.timer(id);
    }

    public Gauge gauge(Id id) {
        return this.composite.gauge(id);
    }

    public Meter get(Id id) {
        return this.composite.get(id);
    }

    public Iterator<Meter> iterator() {
        return this.composite.iterator();
    }

    public <T extends Registry> T underlying(Class<T> c) {
        return (T)this.composite.underlying(c);
    }

    public Id createId(String name, String ... tags) {
        return this.composite.createId(name, tags);
    }

    public Id createId(String name, Map<String, String> tags) {
        return this.composite.createId(name, tags);
    }

    public Counter counter(String name) {
        return this.composite.counter(name);
    }

    public Counter counter(String name, Iterable<Tag> tags) {
        return this.composite.counter(name, tags);
    }

    public Counter counter(String name, String ... tags) {
        return this.composite.counter(name, tags);
    }

    public DistributionSummary distributionSummary(String name) {
        return this.composite.distributionSummary(name);
    }

    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags) {
        return this.composite.distributionSummary(name, tags);
    }

    public DistributionSummary distributionSummary(String name, String ... tags) {
        return this.composite.distributionSummary(name, tags);
    }

    public Timer timer(String name) {
        return this.composite.timer(name);
    }

    public Timer timer(String name, Iterable<Tag> tags) {
        return this.composite.timer(name, tags);
    }

    public Timer timer(String name, String ... tags) {
        return this.composite.timer(name, tags);
    }

    public LongTaskTimer longTaskTimer(Id id) {
        return com.netflix.spectator.api.patterns.LongTaskTimer.get((Registry)this, (Id)id);
    }

    public LongTaskTimer longTaskTimer(String name) {
        return this.longTaskTimer(this.createId(name));
    }

    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return this.longTaskTimer(this.createId(name, tags));
    }

    public LongTaskTimer longTaskTimer(String name, String ... tags) {
        return this.longTaskTimer(this.createId(name, ExternalClockSpectatorRegistry.toIterable(tags)));
    }

    public <T extends Number> T gauge(Id id, T number) {
        return (T)this.composite.gauge(id, number);
    }

    public <T extends Number> T gauge(String name, T number) {
        return (T)this.composite.gauge(name, number);
    }

    public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.composite.gauge(name, tags, number);
    }

    public <T> T gauge(Id id, T obj, ToDoubleFunction<T> f) {
        return (T)this.composite.gauge(id, obj, f);
    }

    public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return (T)this.composite.gauge(name, obj, f);
    }

    public <T extends Collection<?>> T collectionSize(Id id, T collection) {
        return (T)this.composite.collectionSize(id, collection);
    }

    public <T extends Collection<?>> T collectionSize(String name, T collection) {
        return (T)this.composite.collectionSize(name, collection);
    }

    public <T extends Map<?, ?>> T mapSize(Id id, T collection) {
        return (T)this.composite.mapSize(id, collection);
    }

    public <T extends Map<?, ?>> T mapSize(String name, T collection) {
        return (T)this.composite.mapSize(name, collection);
    }

    public void methodValue(Id id, Object obj, String method) {
        this.composite.methodValue(id, obj, method);
    }

    public void methodValue(String name, Object obj, String method) {
        this.composite.methodValue(name, obj, method);
    }

    public Stream<Meter> stream() {
        return this.composite.stream();
    }

    public Stream<Counter> counters() {
        return this.composite.counters();
    }

    public Stream<DistributionSummary> distributionSummaries() {
        return this.composite.distributionSummaries();
    }

    public Stream<Timer> timers() {
        return this.composite.timers();
    }

    public Stream<Gauge> gauges() {
        return this.composite.gauges();
    }

    public void propagate(String msg, Throwable t) {
        this.composite.propagate(msg, t);
    }

    public void propagate(Throwable t) {
        this.composite.propagate(t);
    }

    private static Iterable<Tag> toIterable(String[] tags) {
        if (tags.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        ArrayList<Tag> ts = new ArrayList<Tag>(tags.length);
        for (int i = 0; i < tags.length; i += 2) {
            ts.add((Tag)new BasicTag(tags[i], tags[i + 1]));
        }
        return ts;
    }
}

