/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.function.ToDoubleFunction;
import org.springframework.metrics.instrument.Gauge;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.simple.SimpleUtils;

public class SimpleGauge<T>
implements Gauge {
    private final MeterId id;
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> value;

    public SimpleGauge(MeterId id, T obj, ToDoubleFunction<T> value) {
        this.id = id;
        this.ref = new WeakReference<T>(obj);
        this.value = value;
    }

    @Override
    public double value() {
        return this.value.applyAsDouble(this.ref.get());
    }

    @Override
    public String getName() {
        return this.id.getName();
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.id.getTags();
    }

    @Override
    public Meter.Type getType() {
        return Meter.Type.Gauge;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.singletonList(this.id.withTags(SimpleUtils.typeTag(this.getType())).measurement(this.value()));
    }
}

