/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.springframework.metrics.annotation.Timed;
import org.springframework.metrics.annotation.TimedSet;

public class AnnotationUtils {
    public static Stream<Timed> findTimed(Class<?> clazz) {
        return AnnotationUtils.findTimed(clazz.getAnnotation(Timed.class), clazz.getAnnotation(TimedSet.class));
    }

    public static Stream<Timed> findTimed(Method m) {
        return AnnotationUtils.findTimed(m.getAnnotation(Timed.class), m.getAnnotation(TimedSet.class));
    }

    private static Stream<Timed> findTimed(Timed t, TimedSet ts) {
        if (t != null) {
            return Stream.of(t);
        }
        if (ts != null) {
            return Arrays.stream(ts.value()).sorted(Comparator.comparing(Timed::value));
        }
        return Stream.empty();
    }
}

