/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.internal.MeterId;

public abstract class AbstractTimer
implements Timer {
    protected Clock clock;
    protected MeterId id;

    protected AbstractTimer(MeterId id, Clock clock) {
        this.clock = clock;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> f) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> f) {
        long s = this.clock.monotonicTime();
        try {
            T t = f.get();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public <T> Callable<T> wrap(Callable<T> f) {
        return () -> {
            long s = this.clock.monotonicTime();
            try {
                Object v = f.call();
                return v;
            }
            finally {
                long e = this.clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public String getName() {
        return this.id.getName();
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.id.getTags();
    }

    @Override
    public Meter.Type getType() {
        return Meter.Type.Timer;
    }
}

