/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument;

import com.google.common.cache.Cache;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Tags;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.binder.CacheMetrics;
import org.springframework.metrics.instrument.binder.DataSourceMetrics;
import org.springframework.metrics.instrument.internal.TimedExecutorService;
import org.springframework.metrics.instrument.scheduling.ExecutorServiceMetrics;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class Meters {
    public static Builder build(String name) {
        return new Builder(name);
    }

    public static Cache monitor(MeterRegistry registry, Cache cache, String name, Tag ... tags) {
        new CacheMetrics(name, Arrays.asList(tags), cache).bindTo(registry);
        return cache;
    }

    public static Cache monitor(MeterRegistry registry, Cache cache, String name, Iterable<Tag> tags) {
        new CacheMetrics(name, tags, cache).bindTo(registry);
        return cache;
    }

    public static DataSource monitor(MeterRegistry registry, DataSource dataSource, Collection<DataSourcePoolMetadataProvider> metadataProviders, String name, Iterable<Tag> tags) {
        new DataSourceMetrics(dataSource, metadataProviders, name, tags).bindTo(registry);
        return dataSource;
    }

    public static DataSource monitor(MeterRegistry registry, DataSource dataSource, Collection<DataSourcePoolMetadataProvider> metadataProviders, String name, Tag ... tags) {
        return Meters.monitor(registry, dataSource, metadataProviders, name, Arrays.asList(tags));
    }

    public static Executor monitor(MeterRegistry registry, Executor executor, String name, Iterable<Tag> tags) {
        Timer commandTimer = registry.timer(name, tags);
        return commandTimer::record;
    }

    public static Executor monitor(MeterRegistry registry, Executor executor, String name, Tag ... tags) {
        return Meters.monitor(registry, executor, name, Arrays.asList(tags));
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String name, Iterable<Tag> tags) {
        new ExecutorServiceMetrics(executor, name, tags).bindTo(registry);
        return new TimedExecutorService(registry, executor, name, tags);
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String name, Tag ... tags) {
        return Meters.monitor(registry, executor, name, Arrays.asList(tags));
    }

    public static ThreadPoolTaskExecutor monitor(MeterRegistry registry, ThreadPoolTaskExecutor executor, String name, Iterable<Tag> tags) {
        Meters.monitor(registry, (ExecutorService)executor.getThreadPoolExecutor(), name, tags);
        return executor;
    }

    public static ThreadPoolTaskExecutor monitor(MeterRegistry registry, ThreadPoolTaskExecutor executor, String name, Tag ... tags) {
        Meters.monitor(registry, (ExecutorService)executor.getThreadPoolExecutor(), name, tags);
        return executor;
    }

    public static ThreadPoolTaskScheduler monitor(MeterRegistry registry, ThreadPoolTaskScheduler scheduler, String name, Iterable<Tag> tags) {
        Meters.monitor(registry, (ExecutorService)scheduler.getScheduledExecutor(), name, tags);
        return scheduler;
    }

    public static ThreadPoolTaskScheduler monitor(MeterRegistry registry, ThreadPoolTaskScheduler scheduler, String name, Tag ... tags) {
        Meters.monitor(registry, (ExecutorService)scheduler.getScheduledExecutor(), name, tags);
        return scheduler;
    }

    public static class Builder {
        private final String name;
        private Iterable<Tag> tags = Collections.emptyList();
        private Meter.Type type = Meter.Type.Other;

        Builder(String name) {
            this.name = name;
        }

        public Builder tags(Iterable<Tag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(String ... tags) {
            this.tags = Tags.zip(tags);
            return this;
        }

        public Builder type(Meter.Type type) {
            this.type = type;
            return this;
        }

        public Meter create(final Function<String, Iterable<Measurement>> measure) {
            return new Meter(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public Iterable<Tag> getTags() {
                    return tags;
                }

                @Override
                public Meter.Type getType() {
                    return type;
                }

                @Override
                public Iterable<Measurement> measure() {
                    Iterable measurements = (Iterable)measure.apply(name);
                    measurements.forEach(m -> tags.forEach(t -> m.getTags().add((Tag)t)));
                    return measurements;
                }
            };
        }

        public <T> Meter create(final T obj, final BiFunction<String, T, Iterable<Measurement>> measure) {
            return new Meter(){
                private WeakReference<T> ref;
                {
                    this.ref = new WeakReference<Object>(obj);
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public Iterable<Tag> getTags() {
                    return tags;
                }

                @Override
                public Meter.Type getType() {
                    return type;
                }

                @Override
                public Iterable<Measurement> measure() {
                    if (this.ref.get() != null) {
                        Iterable measurements = (Iterable)measure.apply(name, this.ref.get());
                        measurements.forEach(m -> tags.forEach(t -> m.getTags().add((Tag)t)));
                        return measurements;
                    }
                    return Collections.emptyList();
                }
            };
        }
    }
}

