/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.boot;

import org.aspectj.lang.JoinPoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.metrics.boot.InstrumentRestTemplateConfiguration;
import org.springframework.metrics.boot.InstrumentServletRequestConfiguration;
import org.springframework.metrics.boot.MeterBinderRegistration;
import org.springframework.metrics.boot.RecommendedMeterBinders;
import org.springframework.metrics.boot.RestTemplateUrlTemplateCapturingAspect;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.TagFormatter;
import org.springframework.metrics.instrument.scheduling.MetricsSchedulingAspect;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnMissingClass(value={"org.springframework.web.server.WebFilter"})
@Import(value={InstrumentRestTemplateConfiguration.class, RecommendedMeterBinders.class, MeterBinderRegistration.class})
class MetricsBoot1Configuration {
    MetricsBoot1Configuration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={TagFormatter.class})
    public TagFormatter tagFormatter() {
        return new TagFormatter(){};
    }

    @Bean
    @ConditionalOnClass(value={RestTemplate.class, JoinPoint.class})
    @ConditionalOnProperty(value={"spring.aop.enabled"}, havingValue="true", matchIfMissing=true)
    public MetricsSchedulingAspect metricsSchedulingAspect(MeterRegistry registry) {
        return new MetricsSchedulingAspect(registry);
    }

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class, JoinPoint.class})
    @ConditionalOnProperty(value={"spring.aop.enabled"}, havingValue="true", matchIfMissing=true)
    static class MetricsRestTemplateAspectConfiguration {
        MetricsRestTemplateAspectConfiguration() {
        }

        @Bean
        RestTemplateUrlTemplateCapturingAspect restTemplateUrlTemplateCapturingAspect() {
            return new RestTemplateUrlTemplateCapturingAspect();
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @Import(value={InstrumentServletRequestConfiguration.class})
    static class WebMvcConfiguration {
        WebMvcConfiguration() {
        }
    }
}

