/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.annotation.Timed;
import org.springframework.metrics.instrument.internal.TimedUtils;
import org.springframework.metrics.instrument.web.WebMetricsTagProvider;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class WebmvcMetricsHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Log logger = LogFactory.getLog(WebmvcMetricsHandlerInterceptor.class);
    private static final String TIMING_REQUEST_ATTRIBUTE = "requestStartTime";
    private final MeterRegistry registry;
    private final WebMetricsTagProvider provider;
    private final String metricName;
    private final Map<Timed, Long> longTaskTimerIds = new ConcurrentHashMap<Timed, Long>();

    public WebmvcMetricsHandlerInterceptor(MeterRegistry registry, WebMetricsTagProvider provider, String metricName) {
        this.registry = registry;
        this.provider = provider;
        this.metricName = metricName;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.longTaskTimed(handler).forEach(t -> {
            if (t.value().isEmpty()) {
                logger.warn((Object)("Unable to perform metrics timing on " + ((HandlerMethod)handler).getShortLogMessage() + ": @Timed annotation must have a value used to name the metric"));
                return;
            }
            this.longTaskTimerIds.put((Timed)t, this.registry.longTaskTimer(t.value(), this.provider.httpLongRequestTags(request, handler)).start());
        });
        RequestContextHolder.getRequestAttributes().setAttribute(TIMING_REQUEST_ATTRIBUTE, (Object)System.nanoTime(), 0);
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestContextHolder.getRequestAttributes().setAttribute("exception", (Object)ex, 0);
        Long startTime = (Long)RequestContextHolder.getRequestAttributes().getAttribute(TIMING_REQUEST_ATTRIBUTE, 0);
        if (startTime != null) {
            this.recordMetric(request, response, handler, startTime);
        }
        super.afterCompletion(request, response, handler, ex);
    }

    private void recordMetric(HttpServletRequest request, HttpServletResponse response, Object handler, Long startTime) {
        long endTime = System.nanoTime();
        this.longTaskTimed(handler).forEach(t -> {
            if (!t.value().isEmpty()) {
                this.registry.longTaskTimer(t.value(), this.provider.httpLongRequestTags(request, handler)).stop(this.longTaskTimerIds.remove(t));
            }
        });
        this.timed(handler).forEach(t -> {
            Timer timer;
            String name = this.metricName;
            if (!t.value().isEmpty()) {
                name = t.value();
            }
            Stream<Tag> tags = this.provider.httpRequestTags(request, response, handler);
            String[] extraTags = t.extraTags();
            if (extraTags.length > 0) {
                if (extraTags.length % 2 != 0) {
                    if (logger.isErrorEnabled()) {
                        Method method = ((HandlerMethod)handler).getMethod();
                        String target = method.getDeclaringClass().getName() + "." + method.getName();
                        logger.error((Object)("@Timed extraTags array on method " + target + " size must be even, it is a set of key=value pairs"));
                    }
                } else {
                    Stream<Tag> extraTagsStream = IntStream.range(0, extraTags.length / 2).mapToObj(i -> Tag.of(extraTags[i], extraTags[i + 1]));
                    tags = Stream.concat(tags, extraTagsStream);
                }
            }
            if ((timer = this.registry.timer(name, tags)) != null) {
                timer.record(endTime - startTime, TimeUnit.NANOSECONDS);
            }
        });
    }

    private Set<Timed> longTaskTimed(Object m) {
        if (!(m instanceof HandlerMethod)) {
            return Collections.emptySet();
        }
        Set<Timed> timed = TimedUtils.findTimed(((HandlerMethod)m).getMethod()).filter(Timed::longTask).collect(Collectors.toSet());
        if (timed.isEmpty()) {
            return TimedUtils.findTimed(((HandlerMethod)m).getBeanType()).filter(Timed::longTask).collect(Collectors.toSet());
        }
        return timed;
    }

    private Set<Timed> timed(Object m) {
        if (!(m instanceof HandlerMethod)) {
            return Collections.emptySet();
        }
        Set<Timed> timed = TimedUtils.findTimed(((HandlerMethod)m).getMethod()).filter(t -> !t.longTask()).collect(Collectors.toSet());
        if (timed.isEmpty()) {
            return TimedUtils.findTimed(((HandlerMethod)m).getBeanType()).filter(t -> !t.longTask()).collect(Collectors.toSet());
        }
        return timed;
    }
}

