/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.util.concurrent.TimeUnit;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.web.WebMetricsTagProvider;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebfluxMetricsWebFilter
implements WebFilter {
    private final MeterRegistry registry;
    private final WebMetricsTagProvider tagProvider;
    private final String metricName;

    public WebfluxMetricsWebFilter(MeterRegistry registry, WebMetricsTagProvider tagProvider, String metricName) {
        this.registry = registry;
        this.tagProvider = tagProvider;
        this.metricName = metricName;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        long start = System.nanoTime();
        Mono filtered = chain.filter(exchange);
        return filtered.doOnSuccess(done -> this.registry.timer(this.metricName, this.tagProvider.httpRequestTags(exchange, null)).record(System.nanoTime() - start, TimeUnit.NANOSECONDS)).doOnError(t -> this.registry.timer(this.metricName, this.tagProvider.httpRequestTags(exchange, (Throwable)t)).record(System.nanoTime() - start, TimeUnit.NANOSECONDS));
    }
}

