/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.web.DefaultWebMetricsTagProvider;
import org.springframework.metrics.instrument.web.WebMetricsTagProvider;
import org.springframework.web.reactive.function.server.HandlerFilterFunction;
import org.springframework.web.reactive.function.server.ServerResponse;

public class RouterFunctionMetrics {
    private final MeterRegistry registry;
    private String defaultName = "http_server_requests";
    private WebMetricsTagProvider tagProvider = new DefaultWebMetricsTagProvider();

    public RouterFunctionMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public RouterFunctionMetrics setDefaultName(String defaultName) {
        this.defaultName = defaultName;
        return this;
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer() {
        return this.timer(this.defaultName, Stream.empty());
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(Stream<Tag> tags) {
        return this.timer(this.defaultName, tags);
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name, Stream<Tag> tags) {
        return (request, next) -> {
            long start = System.nanoTime();
            return next.handle(request).doOnSuccess(response -> {
                Stream<Tag> allTags = Stream.concat(tags, this.tagProvider.httpRequestTags(request, (ServerResponse)response, "", null));
                this.registry.timer(name, allTags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            });
        };
    }
}

