/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.web.WebMetricsTagProvider;

public class MetricsClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final MeterRegistry meterRegistry;
    private final WebMetricsTagProvider tagProvider;
    private final String metricName;

    public MetricsClientHttpRequestInterceptor(MeterRegistry meterRegistry, WebMetricsTagProvider tagProvider, String metricName) {
        this.tagProvider = tagProvider;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        long startTime = System.nanoTime();
        ClientHttpResponse response = null;
        try {
            ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
            return clientHttpResponse;
        }
        finally {
            this.meterRegistry.timer(this.metricName, this.tagProvider.clientHttpRequestTags(request, response)).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }
}

