/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.io.IOException;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.web.RestTemplateUrlTemplateHolder;
import org.springframework.metrics.instrument.web.WebMetricsTagProvider;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;

public class DefaultWebMetricsTagProvider
implements WebMetricsTagProvider {
    @Override
    public Stream<Tag> clientHttpRequestTags(HttpRequest request, ClientHttpResponse response) {
        String status;
        String urlTemplate = RestTemplateUrlTemplateHolder.getRestTemplateUrlTemplate();
        if (urlTemplate == null) {
            urlTemplate = "none";
        }
        try {
            status = response == null ? "CLIENT_ERROR" : Integer.valueOf(response.getRawStatusCode()).toString();
        }
        catch (IOException e) {
            status = "IO_ERROR";
        }
        String host = request.getURI().getHost();
        if (host == null) {
            host = "none";
        }
        String strippedUrlTemplate = urlTemplate.replaceAll("^https?://[^/]+/", "");
        return Stream.of(Tag.of("method", request.getMethod().name()), Tag.of("uri", this.sanitizeUrlTemplate(strippedUrlTemplate)), Tag.of("status", status), Tag.of("clientName", host));
    }

    @Override
    public Stream<Tag> httpLongRequestTags(HttpServletRequest request, Object handler) {
        Stream.Builder<Tag> tags = Stream.builder();
        tags.add(Tag.of("method", request.getMethod()));
        String uri = (String)request.getAttribute(org.springframework.web.servlet.HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (uri == null) {
            uri = request.getPathInfo();
        }
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        tags.add(Tag.of("uri", (uri = this.sanitizeUrlTemplate(uri.substring(1))).isEmpty() ? "root" : uri));
        return tags.build();
    }

    @Override
    public Stream<Tag> httpRequestTags(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Stream.Builder<Tag> tags = Stream.builder();
        tags.add(Tag.of("method", request.getMethod()));
        tags.add(Tag.of("status", Integer.valueOf(response.getStatus()).toString()));
        String uri = (String)request.getAttribute(org.springframework.web.servlet.HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (uri == null) {
            uri = request.getPathInfo();
        }
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        tags.add(Tag.of("uri", (uri = this.sanitizeUrlTemplate(uri.substring(1))).isEmpty() ? "root" : uri));
        Object exception = request.getAttribute("exception");
        if (exception != null) {
            tags.add(Tag.of("exception", exception.getClass().getSimpleName()));
        }
        return tags.build();
    }

    @Override
    public Stream<Tag> httpRequestTags(ServerWebExchange exchange, Throwable exception) {
        Stream.Builder<Tag> tags = Stream.builder();
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        tags.add(Tag.of("method", request.getMethod().toString()));
        String uri = exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE).orElse(null);
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        tags.add(Tag.of("uri", (uri = this.sanitizeUrlTemplate(uri.substring(1))).isEmpty() ? "root" : uri));
        if (exception != null) {
            tags.add(Tag.of("exception", exception.getClass().getSimpleName()));
        }
        return tags.build();
    }

    @Override
    public Stream<Tag> httpRequestTags(ServerRequest request, ServerResponse response, String uri, Throwable exception) {
        Stream.Builder<Tag> tags = Stream.builder();
        tags.add(Tag.of("method", request.method().toString()));
        tags.add(Tag.of("status", response.statusCode().toString()));
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        tags.add(Tag.of("uri", (uri = this.sanitizeUrlTemplate(uri.substring(1))).isEmpty() ? "root" : uri));
        if (exception != null) {
            tags.add(Tag.of("exception", exception.getClass().getSimpleName()));
        }
        return tags.build();
    }

    protected String sanitizeUrlTemplate(String urlTemplate) {
        String sanitized = urlTemplate.replaceAll("\\{(\\w+):.+}(?=/|$)", "-$1-").replaceAll("/", "_").replaceAll("[{}]", "-");
        if (!StringUtils.hasText((String)sanitized)) {
            sanitized = "none";
        }
        return sanitized;
    }
}

