/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.spectator;

import com.netflix.spectator.api.Timer;
import java.util.concurrent.TimeUnit;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.internal.AbstractTimer;

public class SpectatorTimer
extends AbstractTimer {
    private Timer timer;

    public SpectatorTimer(Timer timer, Clock clock) {
        super(timer.id().name(), clock);
        this.timer = timer;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.timer.record(unit.toNanos(amount), TimeUnit.NANOSECONDS);
    }

    @Override
    public long count() {
        return this.timer.count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return SpectatorTimer.nanosToUnit(this.timer.totalTime(), unit);
    }
}

