/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.internal.AbstractTimer;

public class SimpleTimer
extends AbstractTimer {
    private AtomicLong count = new AtomicLong(0L);
    private AtomicLong totalTime = new AtomicLong(0L);

    public SimpleTimer(String name) {
        this(name, Clock.SYSTEM);
    }

    public SimpleTimer(String name, Clock clock) {
        super(name, clock);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.count.incrementAndGet();
        this.totalTime.addAndGet(TimeUnit.NANOSECONDS.convert(amount, unit));
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return SimpleTimer.nanosToUnit(this.totalTime.get(), unit);
    }
}

