/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToDoubleFunction;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.DistributionSummary;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.internal.AbstractMeterRegistry;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.simple.SimpleCounter;
import org.springframework.metrics.instrument.simple.SimpleDistributionSummary;
import org.springframework.metrics.instrument.simple.SimpleGauge;
import org.springframework.metrics.instrument.simple.SimpleLongTaskTimer;
import org.springframework.metrics.instrument.simple.SimpleTimer;

public class SimpleMeterRegistry
extends AbstractMeterRegistry {
    private final Map<MeterId, Meter> meterMap = new ConcurrentHashMap<MeterId, Meter>();
    private final Map<Meter, MeterId> idMap = new HashMap<Meter, MeterId>();

    public SimpleMeterRegistry() {
        this(Clock.SYSTEM);
    }

    public SimpleMeterRegistry(Clock clock) {
        super(clock);
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        return (Counter)this.meterMap.computeIfAbsent(new MeterId(name, tags), id -> this.storeId((MeterId)id, new SimpleCounter(name)));
    }

    @Override
    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags) {
        return (DistributionSummary)this.meterMap.computeIfAbsent(new MeterId(name, tags), id -> this.storeId((MeterId)id, new SimpleDistributionSummary(name)));
    }

    @Override
    public Timer timer(String name, Iterable<Tag> tags) {
        return (Timer)this.meterMap.computeIfAbsent(new MeterId(name, tags), id -> this.storeId((MeterId)id, new SimpleTimer(name)));
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return (LongTaskTimer)this.meterMap.computeIfAbsent(new MeterId(name, tags), id -> this.storeId((MeterId)id, new SimpleLongTaskTimer(name, this.getClock())));
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        this.meterMap.computeIfAbsent(new MeterId(name, tags), id -> this.storeId((MeterId)id, new SimpleGauge<Object>(name, obj, f)));
        return obj;
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    public MeterId id(Meter m) {
        return this.idMap.get(m);
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> Arrays.asList(id.getTags()).containsAll(tagsToMatch)).findAny().map(this.meterMap::get).map(m -> m);
    }

    private Meter storeId(MeterId id, Meter m) {
        this.idMap.put(m, id);
        return m;
    }

    public void clear() {
        this.meterMap.clear();
        this.idMap.clear();
    }
}

