/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.util.concurrent.atomic.AtomicLong;
import org.springframework.metrics.instrument.DistributionSummary;

public class SimpleDistributionSummary
implements DistributionSummary {
    private final String name;
    private AtomicLong count = new AtomicLong(0L);
    private double amount = 0.0;

    public SimpleDistributionSummary(String name) {
        this.name = name;
    }

    @Override
    public void record(double amount) {
        this.count.incrementAndGet();
        amount += amount;
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double totalAmount() {
        return this.amount;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

