/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import com.netflix.spectator.impl.AtomicDouble;
import org.springframework.metrics.instrument.Counter;

public class SimpleCounter
implements Counter {
    private final String name;
    private AtomicDouble count = new AtomicDouble(0.0);

    public SimpleCounter(String name) {
        this.name = name;
    }

    @Override
    public void increment() {
        this.count.addAndGet(1.0);
    }

    @Override
    public void increment(double amount) {
        this.count.addAndGet(amount);
    }

    @Override
    public double count() {
        return this.count.get();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

