/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.scheduling;

import com.google.common.base.Functions;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tags;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.annotation.Timed;
import org.springframework.metrics.instrument.internal.TimedUtils;

@Aspect
public class MetricsSchedulingAspect {
    private static final Log logger = LogFactory.getLog(MetricsSchedulingAspect.class);
    private final MeterRegistry registry;

    public MetricsSchedulingAspect(MeterRegistry registry) {
        this.registry = registry;
    }

    @Around(value="execution (@org.springframework.scheduling.annotation.Scheduled  * *.*(..))")
    public Object timeScheduledOperation(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        String signature = pjp.getSignature().toShortString();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = pjp.getTarget().getClass().getDeclaredMethod(pjp.getSignature().getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.warn((Object)("Unable to perform metrics timing on " + signature), (Throwable)e);
                return pjp.proceed();
            }
        }
        Map timedAnnots = TimedUtils.findTimed(method).filter(t -> !t.value().isEmpty()).collect(Collectors.toMap(Timed::longTask, Functions.identity()));
        Timed shortTaskTimerAnnot = (Timed)timedAnnots.get(false);
        Timer shortTaskTimer = null;
        if (shortTaskTimerAnnot != null) {
            shortTaskTimer = this.registry.timer(shortTaskTimerAnnot.value(), Tags.tagList(shortTaskTimerAnnot.extraTags()));
        }
        Timed longTaskTimerAnnot = (Timed)timedAnnots.get(true);
        LongTaskTimer longTaskTimer = null;
        if (longTaskTimerAnnot != null) {
            longTaskTimer = this.registry.longTaskTimer(longTaskTimerAnnot.value(), Tags.tagList(longTaskTimerAnnot.extraTags()));
        }
        if (shortTaskTimer != null && longTaskTimer != null) {
            Timer finalTimer = shortTaskTimer;
            return longTaskTimer.recordThrowable(() -> finalTimer.recordThrowable(() -> ((ProceedingJoinPoint)pjp).proceed()));
        }
        if (shortTaskTimer != null) {
            return shortTaskTimer.recordThrowable(() -> ((ProceedingJoinPoint)pjp).proceed());
        }
        if (longTaskTimer != null) {
            return longTaskTimer.recordThrowable(() -> ((ProceedingJoinPoint)pjp).proceed());
        }
        return pjp.proceed();
    }
}

