/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.prometheus;

import io.prometheus.client.Summary;
import java.util.concurrent.TimeUnit;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.internal.AbstractTimer;

public class PrometheusTimer
extends AbstractTimer {
    private Summary.Child summary;

    public PrometheusTimer(String name, Summary.Child summary, Clock clock) {
        super(name, clock);
        this.summary = summary;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            double nanos = TimeUnit.NANOSECONDS.convert(amount, unit);
            this.summary.observe(nanos / 1.0E9);
        }
    }

    @Override
    public long count() {
        return (long)this.summary.get().count;
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return PrometheusTimer.secondsToUnit(this.summary.get().sum, unit);
    }
}

