/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.Summary;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.DistributionSummary;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.internal.AbstractMeterRegistry;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.prometheus.PrometheusCounter;
import org.springframework.metrics.instrument.prometheus.PrometheusDistributionSummary;
import org.springframework.metrics.instrument.prometheus.PrometheusGauge;
import org.springframework.metrics.instrument.prometheus.PrometheusLongTaskTimer;
import org.springframework.metrics.instrument.prometheus.PrometheusTimer;

public class PrometheusMeterRegistry
extends AbstractMeterRegistry {
    private final CollectorRegistry registry;
    private final Map<String, Collector> collectorMap = new ConcurrentHashMap<String, Collector>();
    private final Map<MeterId, Meter> meterMap = new ConcurrentHashMap<MeterId, Meter>();

    public PrometheusMeterRegistry() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusMeterRegistry(CollectorRegistry registry) {
        this(registry, Clock.SYSTEM);
    }

    @Autowired
    public PrometheusMeterRegistry(CollectorRegistry registry, Clock clock) {
        super(clock);
        this.registry = registry;
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> Arrays.asList(id.getTags()).containsAll(tagsToMatch)).findAny().map(this.meterMap::get).map(m -> m);
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        MeterId id = MeterId.id(name, tags);
        io.prometheus.client.Counter counter = (io.prometheus.client.Counter)this.collectorMap.computeIfAbsent(name, i -> (io.prometheus.client.Counter)this.buildCollector(id, (SimpleCollector.Builder)io.prometheus.client.Counter.build()));
        return (Counter)this.meterMap.computeIfAbsent(id, c -> new PrometheusCounter(name, (Counter.Child)this.child(counter, id.getTags())));
    }

    @Override
    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags) {
        MeterId id = MeterId.id(name, tags);
        Summary summary = (Summary)this.collectorMap.computeIfAbsent(name, i -> (Summary)this.buildCollector(id, (SimpleCollector.Builder)Summary.build()));
        return (DistributionSummary)this.meterMap.computeIfAbsent(id, s -> new PrometheusDistributionSummary(name, (Summary.Child)this.child(summary, id.getTags())));
    }

    @Override
    public Timer timer(String name, Iterable<Tag> tags) {
        MeterId id = MeterId.id(name, tags);
        Summary summary = (Summary)this.collectorMap.computeIfAbsent(name, i -> (Summary)this.buildCollector(id, (SimpleCollector.Builder)Summary.build()));
        return (Timer)this.meterMap.computeIfAbsent(id, s -> new PrometheusTimer(name, (Summary.Child)this.child(summary, id.getTags()), this.getClock()));
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return new PrometheusLongTaskTimer(name, tags, this.getClock());
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, final ToDoubleFunction<T> f) {
        final WeakReference ref = new WeakReference(obj);
        MeterId id = MeterId.id(name, tags);
        Gauge gauge = (Gauge)this.collectorMap.computeIfAbsent(name, i -> (Gauge)this.buildCollector(id, (SimpleCollector.Builder)Gauge.build()));
        this.meterMap.computeIfAbsent(id, g -> {
            gauge.setChild((Object)new Gauge.Child(){

                public double get() {
                    Object obj = ref.get();
                    return obj == null ? Double.NaN : f.applyAsDouble(obj);
                }
            }, new String[0]);
            return new PrometheusGauge(name, (Gauge.Child)this.child(gauge, id.getTags()));
        });
        return obj;
    }

    private <B extends SimpleCollector.Builder<B, C>, C extends SimpleCollector<D>, D> C buildCollector(MeterId id, SimpleCollector.Builder<B, C> builder) {
        return (C)builder.name(id.getName()).help(" ").labelNames(Arrays.stream(id.getTags()).map(Tag::getKey).collect(Collectors.toList()).toArray(new String[0])).register(this.registry);
    }

    private <C extends SimpleCollector<D>, D> D child(C collector, Tag[] tags) {
        return (D)collector.labels(Arrays.stream(tags).map(Tag::getValue).collect(Collectors.toList()).toArray(new String[0]));
    }
}

