/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.Tag;

public class PrometheusLongTaskTimer
extends Collector
implements LongTaskTimer {
    private final ConcurrentMap<Long, Long> tasks = new ConcurrentHashMap<Long, Long>();
    private final AtomicLong nextTask = new AtomicLong(0L);
    private String name;
    private Iterable<Tag> tags;
    private final Clock clock;

    public PrometheusLongTaskTimer(String name, Iterable<Tag> tags, Clock clock) {
        this.tags = tags;
        this.clock = clock;
        this.name = name;
    }

    @Override
    public long start() {
        long task = this.nextTask.getAndIncrement();
        this.tasks.put(task, this.clock.monotonicTime());
        return task;
    }

    @Override
    public long stop(long task) {
        Long startTime = (Long)this.tasks.get(task);
        if (startTime != null) {
            this.tasks.remove(task);
            return this.clock.monotonicTime() - startTime;
        }
        return -1L;
    }

    @Override
    public long duration(long task) {
        Long startTime = (Long)this.tasks.get(task);
        return startTime != null ? this.clock.monotonicTime() - startTime : -1L;
    }

    @Override
    public long duration() {
        long now = this.clock.monotonicTime();
        long sum = 0L;
        Iterator iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            long startTime = (Long)iterator.next();
            sum += now - startTime;
        }
        return sum;
    }

    @Override
    public int activeTasks() {
        return this.tasks.size();
    }

    public List<Collector.MetricFamilySamples> collect() {
        Stream<Tag> tagStream = StreamSupport.stream(this.tags.spliterator(), false);
        List tagNames = Stream.concat(tagStream.map(Tag::getKey), Stream.of("statistic")).collect(Collectors.toList());
        GaugeMetricFamily labeledGauge = new GaugeMetricFamily(this.name, " ", tagNames);
        labeledGauge.addMetric(Stream.concat(tagStream.map(Tag::getValue), Stream.of("activeTasks")).collect(Collectors.toList()), (double)this.activeTasks());
        labeledGauge.addMetric(Stream.concat(tagStream.map(Tag::getValue), Stream.of("duration")).collect(Collectors.toList()), (double)this.duration());
        return Collections.singletonList(labeledGauge);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

