/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.springframework.metrics.instrument.annotation.Timed;
import org.springframework.metrics.instrument.annotation.TimedSet;

public class TimedUtils {
    public static Stream<Timed> findTimed(Class<?> clazz) {
        Timed t = clazz.getAnnotation(Timed.class);
        if (t != null) {
            return Stream.of(t);
        }
        TimedSet ts = clazz.getAnnotation(TimedSet.class);
        if (ts != null) {
            return Arrays.stream(ts.value()).sorted(Comparator.comparing(Timed::value));
        }
        return Stream.empty();
    }

    public static Stream<Timed> findTimed(Method m) {
        Timed t = m.getAnnotation(Timed.class);
        if (t != null) {
            return Stream.of(t);
        }
        TimedSet ts = m.getAnnotation(TimedSet.class);
        if (ts != null) {
            return Arrays.stream(ts.value()).sorted(Comparator.comparing(Timed::value));
        }
        return Stream.empty();
    }
}

