/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.StreamSupport;
import org.springframework.metrics.instrument.Tag;

public class MeterId {
    private final String name;
    private final Tag[] tags;

    public MeterId(String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = (Tag[])StreamSupport.stream(tags.spliterator(), false).sorted(Comparator.comparing(Tag::getKey)).toArray(Tag[]::new);
    }

    public static MeterId id(String name, Iterable<Tag> tags) {
        return new MeterId(name, tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterId meterId = (MeterId)o;
        return (this.name != null ? this.name.equals(meterId.name) : meterId.name == null) && Arrays.equals(this.tags, meterId.tags);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.tags);
        return result;
    }

    public String toString() {
        return "MeterId{name='" + this.name + '\'' + ", tags=" + Arrays.toString(this.tags) + '}';
    }

    public String getName() {
        return this.name;
    }

    public Tag[] getTags() {
        return this.tags;
    }
}

