/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.internal;

import java.util.concurrent.TimeUnit;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.ThrowableCallable;
import org.springframework.metrics.instrument.Timer;

public abstract class AbstractTimer
implements Timer {
    protected Clock clock;
    protected String name;
    private static final long C0 = 1L;
    private static final long C1 = 1000L;
    private static final long C2 = 1000000L;
    private static final long C3 = 1000000000L;
    private static final long C4 = 60000000000L;
    private static final long C5 = 3600000000000L;
    private static final long C6 = 86400000000000L;

    protected AbstractTimer(String name, Clock clock) {
        this.clock = clock;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordThrowable(ThrowableCallable<T> f) throws Throwable {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    protected static double nanosToUnit(double nanos, TimeUnit destinationUnit) {
        switch (destinationUnit) {
            case MICROSECONDS: {
                return nanos / 1000.0;
            }
            case MILLISECONDS: {
                return nanos / 1000000.0;
            }
            case SECONDS: {
                return nanos / 1.0E9;
            }
            case MINUTES: {
                return nanos / 6.0E10;
            }
            case HOURS: {
                return nanos / 3.6E12;
            }
            case DAYS: {
                return nanos / 8.64E13;
            }
        }
        return nanos;
    }

    protected static double secondsToUnit(double seconds, TimeUnit destinationUnit) {
        switch (destinationUnit) {
            case NANOSECONDS: {
                return seconds * 1.0E9;
            }
            case MICROSECONDS: {
                return seconds * 1000000.0;
            }
            case MILLISECONDS: {
                return seconds * 1000.0;
            }
            case MINUTES: {
                return seconds / 60.0;
            }
            case HOURS: {
                return seconds / 3600.0;
            }
            case DAYS: {
                return seconds / 86400.0;
            }
        }
        return seconds;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

