/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProviders;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.binder.MeterBinder;

public abstract class AbstractMeterRegistry
implements MeterRegistry {
    protected Clock clock;
    @Autowired(required=false)
    private Collection<DataSourcePoolMetadataProvider> providers;
    @Autowired(required=false)
    private Collection<MeterBinder> binders;

    @PostConstruct
    private void bind() {
        if (this.binders != null) {
            for (MeterBinder binder : this.binders) {
                this.bind(binder);
            }
        }
    }

    protected AbstractMeterRegistry(Clock clock) {
        this.clock = clock;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public Cache monitor(String name, Stream<Tag> tags, Cache cache) {
        CacheStats stats = cache.stats();
        this.gauge(name + "_size", tags, cache, Cache::size);
        this.gauge(name + "_hit_total", tags, stats, CacheStats::hitCount);
        this.gauge(name + "_miss_total", tags, stats, CacheStats::missCount);
        this.gauge(name + "_requests_total", tags, stats, CacheStats::requestCount);
        this.gauge(name + "_eviction_total", tags, stats, CacheStats::evictionCount);
        this.gauge(name + "_load_duration", tags, stats, CacheStats::totalLoadTime);
        if (cache instanceof LoadingCache) {
            this.gauge(name + "_loads_total", tags, stats, CacheStats::loadCount);
            this.gauge(name + "_load_failure_total", tags, stats, CacheStats::loadExceptionCount);
        }
        return cache;
    }

    @Override
    public DataSource monitor(String name, Stream<Tag> tags, DataSource dataSource) {
        DataSourcePoolMetadataProviders provider = new DataSourcePoolMetadataProviders(this.providers);
        DataSourcePoolMetadata poolMetadata = provider.getDataSourcePoolMetadata(dataSource);
        if (poolMetadata != null) {
            if (poolMetadata.getActive() != null) {
                this.gauge(name + "_active_connections", tags, poolMetadata, DataSourcePoolMetadata::getActive);
            }
            if (poolMetadata.getMax() != null) {
                this.gauge(name + "_max_connections", tags, poolMetadata, DataSourcePoolMetadata::getMax);
            }
            if (poolMetadata.getMin() != null) {
                this.gauge(name + "_min_connections", tags, poolMetadata, DataSourcePoolMetadata::getMin);
            }
        }
        return dataSource;
    }
}

