/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.binder;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotificationEmitter;
import javax.management.openmbean.CompositeData;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.binder.GcGenerationAge;
import org.springframework.metrics.instrument.binder.MeterBinder;

public class JvmGcMetrics
implements MeterBinder {
    private String youngGenPoolName;
    private String oldGenPoolName;

    public JvmGcMetrics() {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (this.isYoungGenPool(mbean.getName())) {
                this.youngGenPoolName = mbean.getName();
            }
            if (!this.isOldGenPool(mbean.getName())) continue;
            this.oldGenPoolName = mbean.getName();
        }
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        AtomicLong maxDataSize = registry.gauge("jvm_gc_max_data_size", new AtomicLong(0L));
        AtomicLong liveDataSize = registry.gauge("jvm_gc_live_data_size", new AtomicLong(0L));
        Counter promotionRate = registry.counter("jvm_gc_promotion_rate");
        Counter allocationRate = registry.counter("jvm_gc_allocation_rate");
        AtomicLong youngGenSizeAfter = new AtomicLong(0L);
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            ((NotificationEmitter)((Object)mbean)).addNotificationListener((notification, ref) -> {
                String type = notification.getType();
                if (type.equals("com.sun.management.gc.notification")) {
                    long delta;
                    CompositeData cd = (CompositeData)notification.getUserData();
                    GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                    registry.timer(this.isConcurrentPhase(notificationInfo) ? "jvm_gc_concurrent_phase_time" : "jvm_gc_pause", "action", notificationInfo.getGcAction(), "cause", notificationInfo.getGcCause()).record(notificationInfo.getGcInfo().getDuration(), TimeUnit.MILLISECONDS);
                    GcInfo gcInfo = notificationInfo.getGcInfo();
                    Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                    Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                    if (this.oldGenPoolName != null) {
                        long oldBefore = before.get(this.oldGenPoolName).getUsed();
                        long oldAfter = after.get(this.oldGenPoolName).getUsed();
                        delta = oldAfter - oldBefore;
                        if (delta > 0L) {
                            promotionRate.increment(delta);
                        }
                        if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                            liveDataSize.set(oldAfter);
                            long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                            maxDataSize.set(oldMaxAfter);
                        }
                    }
                    if (this.youngGenPoolName != null) {
                        long youngBefore = before.get(this.youngGenPoolName).getUsed();
                        long youngAfter = after.get(this.youngGenPoolName).getUsed();
                        delta = youngBefore - youngGenSizeAfter.get();
                        youngGenSizeAfter.set(youngAfter);
                        if (delta > 0L) {
                            allocationRate.increment(delta);
                        }
                    }
                }
            }, null, null);
        }
    }

    private boolean isConcurrentPhase(GarbageCollectionNotificationInfo info) {
        return "No GC".equals(info.getGcCause());
    }

    private boolean isOldGenPool(String name) {
        return name.endsWith("Old Gen") || name.endsWith("Tenured Gen");
    }

    private boolean isYoungGenPool(String name) {
        return name.endsWith("Eden Space");
    }
}

