/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument;

import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.DistributionSummary;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Tags;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.binder.MeterBinder;

public interface MeterRegistry {
    public Collection<Meter> getMeters();

    default public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, String ... tags) {
        return this.findMeter(mClass, name, Tags.tagList(tags));
    }

    default public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Stream<Tag> tags) {
        return this.findMeter(mClass, name, tags);
    }

    public <M extends Meter> Optional<M> findMeter(Class<M> var1, String var2, Iterable<Tag> var3);

    public Clock getClock();

    public Counter counter(String var1, Iterable<Tag> var2);

    default public Counter counter(String name, Stream<Tag> tags) {
        return this.counter(name, tags.collect(Collectors.toList()));
    }

    default public Counter counter(String name) {
        return this.counter(name, Collections.emptyList());
    }

    default public Counter counter(String name, String ... tags) {
        return this.counter(name, Tags.tagList(tags));
    }

    public DistributionSummary distributionSummary(String var1, Iterable<Tag> var2);

    default public DistributionSummary distributionSummary(String name, Stream<Tag> tags) {
        return this.distributionSummary(name, tags.collect(Collectors.toList()));
    }

    default public DistributionSummary distributionSummary(String name) {
        return this.distributionSummary(name, Collections.emptyList());
    }

    default public DistributionSummary distributionSummary(String name, String ... tags) {
        return this.distributionSummary(name, Tags.tagList(tags));
    }

    public Timer timer(String var1, Iterable<Tag> var2);

    default public Timer timer(String name, Stream<Tag> tags) {
        return this.timer(name, tags.collect(Collectors.toList()));
    }

    default public Timer timer(String name) {
        return this.timer(name, Collections.emptyList());
    }

    default public Timer timer(String name, String ... tags) {
        return this.timer(name, Tags.tagList(tags));
    }

    public LongTaskTimer longTaskTimer(String var1, Iterable<Tag> var2);

    default public LongTaskTimer longTaskTimer(String name, Stream<Tag> tags) {
        return this.longTaskTimer(name, tags.collect(Collectors.toList()));
    }

    default public LongTaskTimer longTaskTimer(String name) {
        return this.longTaskTimer(name, Collections.emptyList());
    }

    default public LongTaskTimer longTaskTimer(String name, String ... tags) {
        return this.longTaskTimer(name, Tags.tagList(tags));
    }

    default public <T> T gauge(String name, Stream<Tag> tags, T obj, ToDoubleFunction<T> f) {
        return this.gauge(name, tags.collect(Collectors.toList()), obj, f);
    }

    public <T> T gauge(String var1, Iterable<Tag> var2, T var3, ToDoubleFunction<T> var4);

    default public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.gauge(name, tags, number, Number::doubleValue);
    }

    default public <T extends Number> T gauge(String name, T number) {
        return this.gauge(name, Collections.emptyList(), number);
    }

    default public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(name, Collections.emptyList(), obj, f);
    }

    default public <T extends Collection<?>> T collectionSize(String name, Iterable<Tag> tags, T collection) {
        return (T)this.gauge(name, tags, collection, Collection::size);
    }

    default public <T extends Collection<?>> T collectionSize(String name, T collection) {
        return this.collectionSize(name, Collections.emptyList(), collection);
    }

    default public <T extends Map<?, ?>> T mapSize(String name, Iterable<Tag> tags, T collection) {
        return (T)this.gauge(name, tags, collection, Map::size);
    }

    default public <T extends Map<?, ?>> T mapSize(String name, T collection) {
        return this.mapSize(name, Collections.emptyList(), collection);
    }

    default public MeterRegistry bind(MeterBinder ... binders) {
        for (MeterBinder binder : binders) {
            binder.bindTo(this);
        }
        return this;
    }

    default public Cache monitor(String name, Iterable<Tag> tags, Cache cache) {
        return this.monitor(name, StreamSupport.stream(tags.spliterator(), false), cache);
    }

    public Cache monitor(String var1, Stream<Tag> var2, Cache var3);

    default public Cache monitor(String name, Cache cache) {
        return this.monitor(name, Collections.emptyList(), cache);
    }

    default public DataSource monitor(String name, Iterable<Tag> tags, DataSource dataSource) {
        return this.monitor(name, StreamSupport.stream(tags.spliterator(), false), dataSource);
    }

    public DataSource monitor(String var1, Stream<Tag> var2, DataSource var3);

    default public DataSource monitor(String name, DataSource dataSource) {
        return this.monitor(name, Collections.emptyList(), dataSource);
    }
}

