/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.boot;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

public class MetricsEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Log log = LogFactory.getLog(MetricsEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (ClassUtils.isPresent((String)"com.netflix.servo.monitor.Monitors", null)) {
            log.debug((Object)"Setting 'spring.aop.proxyTargetClass=true' to make spring AOP default to target class so RestTemplates can be customized");
            this.addDefaultProperty(environment, "spring.aop.proxyTargetClass", "true");
        }
    }

    private void addDefaultProperty(ConfigurableEnvironment environment, String name, String value) {
        MutablePropertySources sources = environment.getPropertySources();
        Map<String, String> map = null;
        if (sources.contains("defaultProperties")) {
            PropertySource source = sources.get("defaultProperties");
            if (source instanceof MapPropertySource) {
                map = (Map)((MapPropertySource)source).getSource();
            }
        } else {
            map = new LinkedHashMap<String, String>();
            sources.addLast((PropertySource)new MapPropertySource("defaultProperties", map));
        }
        if (map != null) {
            map.put(name, value);
        }
    }
}

