/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.boot;

import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.metrics.boot.RestTemplateUrlTemplateCapturingAspect;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.scheduling.MetricsSchedulingAspect;
import org.springframework.metrics.instrument.web.DefaultWebMetricsTagProvider;
import org.springframework.metrics.instrument.web.MetricsClientHttpRequestInterceptor;
import org.springframework.metrics.instrument.web.WebMetricsTagProvider;
import org.springframework.metrics.instrument.web.WebmvcMetricsHandlerInterceptor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
class MetricsBoot1Configuration {
    MetricsBoot1Configuration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={WebMetricsTagProvider.class})
    public WebMetricsTagProvider defaultMetricsTagProvider() {
        return new DefaultWebMetricsTagProvider();
    }

    @Bean
    @ConditionalOnClass(value={RestTemplate.class, JoinPoint.class})
    @ConditionalOnProperty(value={"spring.aop.enabled"}, havingValue="true", matchIfMissing=true)
    public MetricsSchedulingAspect metricsSchedulingAspect(MeterRegistry registry) {
        return new MetricsSchedulingAspect(registry);
    }

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class})
    static class MetricsRestTemplateConfiguration {
        MetricsRestTemplateConfiguration() {
        }

        @Bean
        MetricsClientHttpRequestInterceptor spectatorLoggingClientHttpRequestInterceptor(MeterRegistry meterRegistry, WebMetricsTagProvider tagProvider, Environment environment) {
            return new MetricsClientHttpRequestInterceptor(meterRegistry, tagProvider, environment.getProperty("spring.metrics.web.client_requests.name", "http_client_requests"));
        }

        @Bean
        BeanPostProcessor spectatorRestTemplateInterceptorPostProcessor() {
            return new MetricsInterceptorPostProcessor();
        }

        private static class MetricsInterceptorPostProcessor
        implements BeanPostProcessor,
        ApplicationContextAware {
            private ApplicationContext context;
            private MetricsClientHttpRequestInterceptor interceptor;

            private MetricsInterceptorPostProcessor() {
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) {
                if (bean instanceof RestTemplate) {
                    if (this.interceptor == null) {
                        this.interceptor = (MetricsClientHttpRequestInterceptor)this.context.getBean(MetricsClientHttpRequestInterceptor.class);
                    }
                    RestTemplate restTemplate = (RestTemplate)bean;
                    ArrayList<MetricsClientHttpRequestInterceptor> interceptors = new ArrayList<MetricsClientHttpRequestInterceptor>();
                    interceptors.add(this.interceptor);
                    interceptors.addAll(restTemplate.getInterceptors());
                    restTemplate.setInterceptors(interceptors);
                }
                return bean;
            }

            public void setApplicationContext(ApplicationContext context) throws BeansException {
                this.context = context;
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class, JoinPoint.class})
    @ConditionalOnProperty(value={"spring.aop.enabled"}, havingValue="true", matchIfMissing=true)
    static class MetricsRestTemplateAspectConfiguration {
        MetricsRestTemplateAspectConfiguration() {
        }

        @Bean
        RestTemplateUrlTemplateCapturingAspect restTemplateUrlTemplateCapturingAspect() {
            return new RestTemplateUrlTemplateCapturingAspect();
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    static class WebMetricsTagProviderConfiguration {
        WebMetricsTagProviderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={WebMetricsTagProvider.class})
        @ConditionalOnClass(name={"javax.servlet.http.HttpServletRequest"})
        public WebMetricsTagProvider defaultMetricsTagProvider() {
            return new DefaultWebMetricsTagProvider();
        }

        @Bean
        @ConditionalOnMissingBean(value={WebMetricsTagProvider.class})
        @ConditionalOnMissingClass(value={"javax.servlet.http.HttpServletRequest"})
        public WebMetricsTagProvider emptyMetricsTagProvider() {
            return new WebMetricsTagProvider(){};
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    @Import(value={WebMetricsTagProviderConfiguration.class})
    static class WebMvcConfiguration
    extends WebMvcConfigurerAdapter {
        @Autowired
        MeterRegistry registry;
        @Autowired
        WebMetricsTagProvider tagProvider;
        @Autowired
        Environment environment;

        WebMvcConfiguration() {
        }

        @Bean
        WebmvcMetricsHandlerInterceptor webMetricsInterceptor() {
            return new WebmvcMetricsHandlerInterceptor(this.registry, this.tagProvider, this.environment.getProperty("spring.metrics.web.server_requests.name", "http_server_requests"));
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.webMetricsInterceptor());
        }
    }
}

