/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.support.AbstractKafkaHeaderMapper;
import org.springframework.messaging.MessageHeaders;

public class SimpleKafkaHeaderMapper
extends AbstractKafkaHeaderMapper {
    private static final Set<String> NEVER = new HashSet<String>();

    public SimpleKafkaHeaderMapper() {
        super("!id", "!timestamp", "*");
    }

    public SimpleKafkaHeaderMapper(String ... patterns) {
        this(true, patterns);
    }

    private SimpleKafkaHeaderMapper(boolean outbound, String ... patterns) {
        super(outbound, patterns);
    }

    public static SimpleKafkaHeaderMapper forInboundOnlyWithMatchers(String ... patterns) {
        return new SimpleKafkaHeaderMapper(false, patterns);
    }

    @Override
    public void fromHeaders(MessageHeaders headers, Headers target) {
        headers.forEach((key, value) -> {
            if (!NEVER.contains(key)) {
                if (this.doesMatchMultiValueHeader((String)key)) {
                    if (value instanceof Iterable) {
                        Iterable valuesToMap = (Iterable)value;
                        valuesToMap.forEach(o -> this.fromHeader((String)key, o, target));
                    } else {
                        this.fromHeader((String)key, value, target);
                    }
                } else {
                    this.fromHeader((String)key, value, target);
                }
            }
        });
    }

    @Override
    public void toHeaders(Headers source, Map<String, Object> headers) {
        source.forEach(header -> {
            String headerName = header.key();
            if (this.matchesForInbound(headerName)) {
                if (headerName.equals("kafka_deliveryAttempt")) {
                    headers.put(headerName, ByteBuffer.wrap(header.value()).getInt());
                } else {
                    this.fromUserHeader(headerName, (Header)header, headers);
                }
            }
        });
    }

    private void fromHeader(String key, Object value, Headers target) {
        byte[] valueToAdd;
        Object object = this.headerValueToAddOut(key, value);
        if (object instanceof byte[] && this.matches(key, valueToAdd = (byte[])object)) {
            target.add((Header)new RecordHeader(key, valueToAdd));
        }
    }

    static {
        NEVER.add("kafka_deliveryAttempt");
        NEVER.add("kafka_listenerInfo");
    }
}

