/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.clients.consumer.ShareConsumer;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.serialization.Deserializer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.kafka.core.KafkaResourceFactory;
import org.springframework.kafka.core.ShareConsumerFactory;
import org.springframework.util.Assert;

public class DefaultShareConsumerFactory<K, V>
extends KafkaResourceFactory
implements ShareConsumerFactory<K, V>,
BeanNameAware {
    private final Map<String, Object> configs;
    private @Nullable Supplier<@Nullable Deserializer<K>> keyDeserializerSupplier;
    private @Nullable Supplier<@Nullable Deserializer<V>> valueDeserializerSupplier;
    private boolean configureDeserializers = true;
    private final List<ShareConsumerFactory.Listener<K, V>> listeners = new ArrayList<ShareConsumerFactory.Listener<K, V>>();
    private String beanName = "not.managed.by.Spring";

    public DefaultShareConsumerFactory(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public DefaultShareConsumerFactory(Map<String, Object> configs, @Nullable Supplier<@Nullable Deserializer<K>> keyDeserializerSupplier, @Nullable Supplier<@Nullable Deserializer<V>> valueDeserializerSupplier) {
        this(configs, keyDeserializerSupplier, valueDeserializerSupplier, true);
    }

    public DefaultShareConsumerFactory(Map<String, Object> configs, @Nullable Deserializer<K> keyDeserializer, @Nullable Deserializer<V> valueDeserializer, boolean configureDeserializers) {
        this(configs, keyDeserializer != null ? () -> keyDeserializer : null, valueDeserializer != null ? () -> valueDeserializer : null, configureDeserializers);
    }

    public DefaultShareConsumerFactory(Map<String, Object> configs, @Nullable Supplier<@Nullable Deserializer<K>> keyDeserializerSupplier, @Nullable Supplier<@Nullable Deserializer<V>> valueDeserializerSupplier, boolean configureDeserializers) {
        this.configs = new ConcurrentHashMap<String, Object>(configs);
        this.configureDeserializers = configureDeserializers;
        this.keyDeserializerSupplier = keyDeserializerSupplier;
        this.valueDeserializerSupplier = valueDeserializerSupplier;
    }

    @Override
    public ShareConsumer<K, V> createShareConsumer(@Nullable String groupId, @Nullable String clientId) {
        return this.createRawConsumer(groupId, clientId);
    }

    protected ShareConsumer<K, V> createRawConsumer(@Nullable String groupId, @Nullable String clientId) {
        HashMap<String, Object> consumerProperties = new HashMap<String, Object>(this.configs);
        if (groupId != null) {
            consumerProperties.put("group.id", groupId);
        }
        if (clientId != null) {
            consumerProperties.put("client.id", clientId);
        }
        return new ExtendedShareConsumer(consumerProperties);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setKeyDeserializer(@Nullable Deserializer<K> keyDeserializer) {
        this.keyDeserializerSupplier = () -> keyDeserializer;
    }

    public void setValueDeserializer(@Nullable Deserializer<V> valueDeserializer) {
        this.valueDeserializerSupplier = () -> valueDeserializer;
    }

    @Override
    public @Nullable Deserializer<K> getKeyDeserializer() {
        return this.keyDeserializerSupplier != null ? this.keyDeserializerSupplier.get() : null;
    }

    @Override
    public @Nullable Deserializer<V> getValueDeserializer() {
        return this.valueDeserializerSupplier != null ? this.valueDeserializerSupplier.get() : null;
    }

    public void setKeyDeserializerSupplier(@Nullable Supplier<@Nullable Deserializer<K>> keyDeserializerSupplier) {
        this.keyDeserializerSupplier = keyDeserializerSupplier;
    }

    public void setValueDeserializerSupplier(@Nullable Supplier<@Nullable Deserializer<V>> valueDeserializerSupplier) {
        this.valueDeserializerSupplier = valueDeserializerSupplier;
    }

    public void setConfigureDeserializers(boolean configureDeserializers) {
        this.configureDeserializers = configureDeserializers;
    }

    @Override
    public List<ShareConsumerFactory.Listener<K, V>> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void addListener(ShareConsumerFactory.Listener<K, V> listener) {
        Assert.notNull(listener, (String)"'listener' cannot be null");
        this.listeners.add(listener);
    }

    @Override
    public void addListener(int index, ShareConsumerFactory.Listener<K, V> listener) {
        Assert.notNull(listener, (String)"'listener' cannot be null");
        if (index >= this.listeners.size()) {
            this.listeners.add(listener);
        } else {
            this.listeners.add(index, listener);
        }
    }

    @Override
    public boolean removeListener(ShareConsumerFactory.Listener<K, V> listener) {
        return this.listeners.remove(listener);
    }

    private @Nullable Deserializer<K> keyDeserializer(Map<String, Object> configs) {
        Deserializer<K> deserializer;
        Deserializer<K> deserializer2 = deserializer = this.keyDeserializerSupplier != null ? this.keyDeserializerSupplier.get() : null;
        if (deserializer != null && this.configureDeserializers) {
            deserializer.configure(configs, true);
        }
        return deserializer;
    }

    private @Nullable Deserializer<V> valueDeserializer(Map<String, Object> configs) {
        Deserializer<V> deserializer;
        Deserializer<V> deserializer2 = deserializer = this.valueDeserializerSupplier != null ? this.valueDeserializerSupplier.get() : null;
        if (deserializer != null && this.configureDeserializers) {
            deserializer.configure(configs, false);
        }
        return deserializer;
    }

    @Override
    public Map<String, Object> getConfigurationProperties() {
        return Collections.unmodifiableMap(this.configs);
    }

    protected class ExtendedShareConsumer
    extends KafkaShareConsumer<K, V> {
        private @Nullable String idForListeners;

        protected ExtendedShareConsumer(Map<String, Object> configProps) {
            super(configProps, DefaultShareConsumerFactory.this.keyDeserializer(configProps), DefaultShareConsumerFactory.this.valueDeserializer(configProps));
            if (!DefaultShareConsumerFactory.this.listeners.isEmpty()) {
                Iterator metricIterator = this.metrics().keySet().iterator();
                String clientId = "unknown";
                if (metricIterator.hasNext()) {
                    clientId = (String)((MetricName)metricIterator.next()).tags().get("client-id");
                }
                this.idForListeners = DefaultShareConsumerFactory.this.beanName + "." + clientId;
                for (ShareConsumerFactory.Listener listener : DefaultShareConsumerFactory.this.listeners) {
                    listener.consumerAdded(this.idForListeners, this);
                }
            }
        }

        public void close() {
            super.close();
            this.notifyConsumerRemoved();
        }

        public void close(Duration timeout) {
            super.close(timeout);
            this.notifyConsumerRemoved();
        }

        private void notifyConsumerRemoved() {
            for (ShareConsumerFactory.Listener listener : DefaultShareConsumerFactory.this.listeners) {
                listener.consumerRemoved(this.idForListeners, this);
            }
        }
    }
}

