/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.annotation.RetryableTopic;
import org.springframework.kafka.annotation.RetryableTopicAnnotationProcessor;
import org.springframework.kafka.retrytopic.RetryTopicConfiguration;
import org.springframework.util.Assert;

public class RetryTopicConfigurationProvider {
    private final @Nullable BeanFactory beanFactory;
    private final @Nullable BeanExpressionResolver resolver;
    private final @Nullable BeanExpressionContext expressionContext;
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(RetryTopicConfigurationProvider.class));

    public RetryTopicConfigurationProvider(@Nullable BeanFactory beanFactory) {
        this(beanFactory, (BeanExpressionResolver)new StandardBeanExpressionResolver(), beanFactory instanceof ConfigurableBeanFactory ? new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null) : null);
    }

    public RetryTopicConfigurationProvider(@Nullable BeanFactory beanFactory, @Nullable BeanExpressionResolver resolver, @Nullable BeanExpressionContext expressionContext) {
        this.beanFactory = beanFactory;
        this.resolver = resolver;
        this.expressionContext = expressionContext;
    }

    public @Nullable RetryTopicConfiguration findRetryConfigurationFor(String[] topics, Method method, Object bean) {
        return this.findRetryConfigurationFor(topics, method, null, bean);
    }

    public @Nullable RetryTopicConfiguration findRetryConfigurationFor(String[] topics, @Nullable Method method, @Nullable Class<?> clazz, Object bean) {
        RetryableTopic annotation = this.getRetryableTopicAnnotationFromAnnotatedElement(Objects.requireNonNullElse(method, clazz));
        Class<?> declaringClass = method != null ? method.getDeclaringClass() : clazz;
        Assert.state((declaringClass != null ? 1 : 0) != 0, (String)("No declaring class found for " + String.valueOf(method)));
        return annotation != null ? new RetryableTopicAnnotationProcessor(this.beanFactory, this.resolver, this.expressionContext).processAnnotation(topics, declaringClass, annotation, bean) : this.maybeGetFromContext(topics);
    }

    private @Nullable RetryableTopic getRetryableTopicAnnotationFromAnnotatedElement(AnnotatedElement element) {
        return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.none()).get(RetryableTopic.class).synthesize(MergedAnnotation::isPresent).orElse(null);
    }

    private @Nullable RetryTopicConfiguration maybeGetFromContext(String[] topics) {
        if (this.beanFactory == null || !ListableBeanFactory.class.isAssignableFrom(this.beanFactory.getClass())) {
            LOGGER.warn((CharSequence)"No ListableBeanFactory found, skipping RetryTopic configuration.");
            return null;
        }
        Map retryTopicProcessors = ((ListableBeanFactory)this.beanFactory).getBeansOfType(RetryTopicConfiguration.class);
        return retryTopicProcessors.values().stream().filter(topicConfiguration -> topicConfiguration.hasConfigurationForTopics(topics)).findFirst().orElse(null);
    }
}

