/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.jspecify.annotations.Nullable;

public class TopicPartitionOffset {
    private final TopicPartition topicPartition;
    private final @Nullable SeekPosition position;
    private @Nullable Long offset;
    private boolean relativeToCurrent;
    private @Nullable Function<Long, Long> offsetComputeFunction;

    public TopicPartitionOffset(String topic, int partition) {
        this(topic, partition, null, false);
    }

    public TopicPartitionOffset(@Nullable String topic, int partition, @Nullable Long offset) {
        this(topic, partition, offset, false);
    }

    public TopicPartitionOffset(@Nullable String topic, int partition, Function<Long, Long> offsetComputeFunction) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.offsetComputeFunction = offsetComputeFunction;
        this.position = null;
    }

    public TopicPartitionOffset(@Nullable String topic, int partition, @Nullable Long offset, boolean relativeToCurrent) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.offset = offset;
        this.relativeToCurrent = relativeToCurrent;
        this.position = null;
    }

    public TopicPartitionOffset(String topic, int partition, SeekPosition position) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.offset = null;
        this.relativeToCurrent = false;
        this.position = position;
    }

    public TopicPartitionOffset(@Nullable String topic, int partition, @Nullable Long offset, @Nullable SeekPosition position) {
        this(new TopicPartition(topic, partition), offset, position);
    }

    public TopicPartitionOffset(TopicPartition topicPartition, @Nullable Long offset, @Nullable SeekPosition position) {
        this.topicPartition = topicPartition;
        this.offset = offset;
        this.relativeToCurrent = false;
        this.position = position;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public int getPartition() {
        return this.topicPartition.partition();
    }

    public String getTopic() {
        return this.topicPartition.topic();
    }

    public @Nullable Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public boolean isRelativeToCurrent() {
        return this.relativeToCurrent;
    }

    public void setRelativeToCurrent(boolean relativeToCurrent) {
        this.relativeToCurrent = relativeToCurrent;
    }

    public @Nullable SeekPosition getPosition() {
        return this.position;
    }

    public @Nullable Function<Long, Long> getOffsetComputeFunction() {
        return this.offsetComputeFunction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionOffset that = (TopicPartitionOffset)o;
        return Objects.equals(this.topicPartition, that.topicPartition) && Objects.equals((Object)this.position, (Object)that.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topicPartition, this.position});
    }

    public String toString() {
        return "TopicPartitionOffset{topicPartition=" + String.valueOf(this.topicPartition) + ", offset=" + this.offset + ", relativeToCurrent=" + this.relativeToCurrent + (String)(this.position == null ? "" : ", position=" + this.position.name()) + "}";
    }

    public static enum SeekPosition {
        BEGINNING,
        END,
        TIMESTAMP;

    }
}

