/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class KafkaUtils {
    public static final String DESERIALIZER_EXCEPTION_HEADER_PREFIX = "springDeserializerException";
    public static final String KEY_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionKey";
    public static final String VALUE_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionValue";
    private static Function<ProducerRecord<?, ?>, String> prFormatter = ProducerRecord::toString;
    private static Function<ConsumerRecord<?, ?>, String> crFormatter = rec -> rec.topic() + "-" + rec.partition() + "@" + rec.offset();
    public static final boolean MICROMETER_PRESENT = ClassUtils.isPresent((String)"io.micrometer.core.instrument.MeterRegistry", (ClassLoader)KafkaUtils.class.getClassLoader());
    private static final Map<Thread, String> GROUP_IDS = new ConcurrentHashMap<Thread, String>();

    public static boolean returnTypeMessageOrCollectionOf(Method method) {
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType prt = (ParameterizedType)returnType;
            if (Collection.class.equals((Object)(returnType = prt.getRawType()))) {
                returnType = prt.getActualTypeArguments()[0];
            }
            if (returnType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)returnType;
                returnType = pType.getRawType();
            }
        }
        return Message.class.equals((Object)returnType);
    }

    public static void setConsumerGroupId(String groupId) {
        if (groupId != null) {
            GROUP_IDS.put(Thread.currentThread(), groupId);
        }
    }

    public static String getConsumerGroupId() {
        return GROUP_IDS.get(Thread.currentThread());
    }

    public static void clearConsumerGroupId() {
        GROUP_IDS.remove(Thread.currentThread());
    }

    public static Duration determineSendTimeout(Map<String, Object> producerProps, long buffer, long min) {
        Object dt = producerProps.get("delivery.timeout.ms");
        if (dt instanceof Number) {
            Number number = (Number)dt;
            return Duration.ofMillis(Math.max(number.longValue() + buffer, min));
        }
        if (dt instanceof String) {
            String str = (String)dt;
            try {
                return Duration.ofMillis(Math.max(Long.parseLong(str) + buffer, min));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Duration.ofMillis(Math.max(((Integer)ProducerConfig.configDef().defaultValues().get("delivery.timeout.ms")).longValue() + buffer, min));
    }

    @Deprecated(since="3.1", forRemoval=true)
    public static void setLogOnlyMetadata(boolean onlyMeta) {
    }

    public static void setConsumerRecordFormatter(Function<ConsumerRecord<?, ?>, String> formatter) {
        Assert.notNull(formatter, (String)"'formatter' cannot be null");
        crFormatter = formatter;
    }

    public static void setProducerRecordFormatter(Function<ProducerRecord<?, ?>, String> formatter) {
        Assert.notNull(formatter, (String)"'formatter' cannot be null");
        prFormatter = formatter;
    }

    public static String format(ConsumerRecord<?, ?> record) {
        return crFormatter.apply(record);
    }

    public static String format(ProducerRecord<?, ?> record) {
        return prFormatter.apply(record);
    }

    private KafkaUtils() {
    }
}

