/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.BatchAcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.KafkaListenerErrorHandler;
import org.springframework.kafka.listener.adapter.BatchToRecordAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.BatchMessagingMessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class BatchMessagingMessageListenerAdapter<K, V>
extends MessagingMessageListenerAdapter<K, V>
implements BatchAcknowledgingConsumerAwareMessageListener<K, V> {
    private BatchMessageConverter batchMessageConverter = new BatchMessagingMessageConverter();
    private BatchToRecordAdapter<K, V> batchToRecordAdapter;

    public BatchMessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, null);
    }

    public BatchMessagingMessageListenerAdapter(Object bean, Method method, @Nullable KafkaListenerErrorHandler errorHandler) {
        super(bean, method, errorHandler);
    }

    public void setBatchMessageConverter(BatchMessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' cannot be null");
        this.batchMessageConverter = messageConverter;
        RecordMessageConverter recordMessageConverter = messageConverter.getRecordMessageConverter();
        if (recordMessageConverter != null) {
            this.setMessageConverter(recordMessageConverter);
        }
    }

    public void setBatchToRecordAdapter(BatchToRecordAdapter<K, V> batchToRecordAdapter) {
        this.batchToRecordAdapter = batchToRecordAdapter;
    }

    protected final BatchMessageConverter getBatchMessageConverter() {
        return this.batchMessageConverter;
    }

    @Override
    public boolean wantsPollResult() {
        return this.isConsumerRecords();
    }

    @Override
    public void onMessage(ConsumerRecords<K, V> records, @Nullable Acknowledgment acknowledgment, Consumer<K, V> consumer) {
        this.invoke(records, acknowledgment, consumer, NULL_MESSAGE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onMessage(List<ConsumerRecord<K, V>> records, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        Message message;
        if (!this.isConsumerRecordList()) {
            if (this.isMessageList() || this.batchToRecordAdapter != null) {
                ArrayList messages = new ArrayList(records.size());
                for (ConsumerRecord<K, V> cRecord : records) {
                    messages.add(this.toMessagingMessage(cRecord, acknowledgment, consumer));
                }
                if (this.batchToRecordAdapter != null) {
                    this.logger.debug(() -> "Processing " + String.valueOf(messages));
                    this.batchToRecordAdapter.adapt(messages, records, acknowledgment, consumer, this::invoke);
                    return;
                }
                message = MessageBuilder.withPayload(messages).build();
            } else {
                message = this.toMessagingMessage(records, acknowledgment, consumer);
            }
        } else {
            message = NULL_MESSAGE;
        }
        this.logger.debug(() -> "Processing [" + String.valueOf(message) + "]");
        this.invoke(records, acknowledgment, consumer, message);
    }

    protected Message<?> toMessagingMessage(List records, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        return this.getBatchMessageConverter().toMessage(records, acknowledgment, consumer, this.getType());
    }
}

