/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class MicrometerHolder {
    private static final String NONE_EXCEPTION_METERS_KEY = "none";
    private final Map<String, Timer> meters = new ConcurrentHashMap<String, Timer>();
    private final MeterRegistry registry;
    private final String timerName;
    private final String timerDesc;
    private final String name;
    private final Function<Object, Map<String, String>> tagsProvider;

    @Deprecated
    public MicrometerHolder(@Nullable ApplicationContext context, String name, String timerName, String timerDesc, Map<String, String> tags) {
        this(context, name, timerName, timerDesc, (Object cr) -> tags);
    }

    public MicrometerHolder(@Nullable ApplicationContext context, String name, String timerName, String timerDesc, Function<Object, Map<String, String>> tagsProvider) {
        Assert.notNull(tagsProvider, (String)"'tagsProvider' cannot be null");
        if (context == null) {
            throw new IllegalStateException("No micrometer registry present");
        }
        try {
            this.registry = (MeterRegistry)context.getBeanProvider(MeterRegistry.class).getIfUnique();
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException(ex);
        }
        if (this.registry == null) {
            throw new IllegalStateException("No micrometer registry present (or more than one and there is not exactly one marked with @Primary)");
        }
        this.timerName = timerName;
        this.timerDesc = timerDesc;
        this.name = name;
        this.tagsProvider = tagsProvider;
        this.buildTimer(NONE_EXCEPTION_METERS_KEY, null);
    }

    public Object start() {
        return Timer.start((MeterRegistry)this.registry);
    }

    public void success(Object sample) {
        Timer timer = this.meters.get(NONE_EXCEPTION_METERS_KEY);
        if (timer != null) {
            ((Timer.Sample)sample).stop(timer);
        }
    }

    public void failure(Object sample, String exception) {
        Timer timer = this.meters.get(exception);
        if (timer == null) {
            timer = this.buildTimer(exception, null);
        }
        ((Timer.Sample)sample).stop(timer);
    }

    public void success(Object sample, Object record) {
        Timer timer = this.buildTimer(NONE_EXCEPTION_METERS_KEY, record);
        if (timer != null) {
            ((Timer.Sample)sample).stop(timer);
        }
    }

    public void failure(Object sample, String exception, Object record) {
        Timer timer = this.buildTimer(exception, record);
        ((Timer.Sample)sample).stop(timer);
    }

    private Timer buildTimer(String exception, @Nullable Object record) {
        Timer.Builder builder = Timer.builder((String)this.timerName).description(this.timerDesc).tag("name", this.name).tag("result", exception.equals(NONE_EXCEPTION_METERS_KEY) ? "success" : "failure").tag("exception", exception);
        Map<String, String> extra = this.tagsProvider.apply(record);
        if (extra != null && !extra.isEmpty()) {
            extra.forEach((arg_0, arg_1) -> ((Timer.Builder)builder).tag(arg_0, arg_1));
        }
        Timer registeredTimer = builder.register(this.registry);
        if (record == null) {
            this.meters.put(exception, registeredTimer);
        }
        return registeredTimer;
    }

    public void destroy() {
        this.meters.values().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.meters.clear();
    }
}

