/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.listener.DeliveryAttemptAware;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.TopicPartitionOffset;

public interface CommonErrorHandler
extends DeliveryAttemptAware {
    @Deprecated
    default public boolean remainingRecords() {
        return false;
    }

    default public boolean seeksAfterHandling() {
        return this.remainingRecords();
    }

    default public boolean deliveryAttemptHeader() {
        return false;
    }

    default public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        LogFactory.getLog(this.getClass()).error((Object)"'handleOtherException' is not implemented by this handler", (Throwable)thrownException);
    }

    @Deprecated
    default public void handleRecord(Exception thrownException, ConsumerRecord<?, ?> record, Consumer<?, ?> consumer, MessageListenerContainer container) {
        LogFactory.getLog(this.getClass()).error((Object)"'handleRecord' is not implemented by this handler", (Throwable)thrownException);
    }

    default public boolean handleOne(Exception thrownException, ConsumerRecord<?, ?> record, Consumer<?, ?> consumer, MessageListenerContainer container) {
        try {
            this.handleRecord(thrownException, record, consumer, container);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    default public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        LogFactory.getLog(this.getClass()).error((Object)"'handleRemaining' is not implemented by this handler", (Throwable)thrownException);
    }

    default public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        LogFactory.getLog(this.getClass()).error((Object)"'handleBatch' is not implemented by this handler", (Throwable)thrownException);
    }

    default public <K, V> ConsumerRecords<K, V> handleBatchAndReturnRemaining(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        this.handleBatch(thrownException, data, consumer, container, invokeListener);
        return ConsumerRecords.empty();
    }

    @Override
    default public int deliveryAttempt(TopicPartitionOffset topicPartitionOffset) {
        return 0;
    }

    default public void clearThreadState() {
    }

    default public boolean isAckAfterHandle() {
        return true;
    }

    default public void setAckAfterHandle(boolean ack) {
        throw new UnsupportedOperationException("This error handler does not support setting this property");
    }

    @Deprecated
    default public void onPartitionsAssigned(Consumer<?, ?> consumer, Collection<TopicPartition> partitions) {
    }

    default public void onPartitionsAssigned(Consumer<?, ?> consumer, Collection<TopicPartition> partitions, Runnable publishPause) {
        this.onPartitionsAssigned(consumer, partitions);
    }
}

