/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.errors.SerializationException;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConsumerRecordRecoverer;
import org.springframework.kafka.listener.ErrorHandlerAdapter;
import org.springframework.kafka.listener.FailedBatchProcessor;
import org.springframework.kafka.listener.FallbackBatchErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.SeekUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.backoff.BackOff;

public class DefaultErrorHandler
extends FailedBatchProcessor
implements CommonErrorHandler {
    private boolean ackAfterHandle = true;

    public DefaultErrorHandler() {
        this((ConsumerRecordRecoverer)null, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    public DefaultErrorHandler(BackOff backOff) {
        this((ConsumerRecordRecoverer)null, backOff);
    }

    public DefaultErrorHandler(ConsumerRecordRecoverer recoverer) {
        this(recoverer, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    public DefaultErrorHandler(@Nullable ConsumerRecordRecoverer recoverer, BackOff backOff) {
        super(recoverer, backOff, DefaultErrorHandler.createFallback(backOff, recoverer));
    }

    private static CommonErrorHandler createFallback(BackOff backOff, @Nullable ConsumerRecordRecoverer recoverer) {
        return new ErrorHandlerAdapter(new FallbackBatchErrorHandler(backOff, recoverer));
    }

    @Override
    public void setCommitRecovered(boolean commitRecovered) {
        super.setCommitRecovered(commitRecovered);
    }

    @Override
    public boolean isAckAfterHandle() {
        return this.ackAfterHandle;
    }

    @Override
    public void setAckAfterHandle(boolean ackAfterHandle) {
        this.ackAfterHandle = ackAfterHandle;
    }

    @Override
    public boolean remainingRecords() {
        return true;
    }

    @Override
    public boolean deliveryAttemptHeader() {
        return true;
    }

    @Override
    public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        SeekUtils.seekOrRecover(thrownException, records, consumer, container, this.isCommitRecovered(), this.getRecoveryStrategy(records, thrownException), this.logger, this.getLogLevel());
    }

    @Override
    public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        this.doHandle(thrownException, data, consumer, container, invokeListener);
    }

    @Override
    public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        if (thrownException instanceof SerializationException) {
            throw new IllegalStateException("This error handler cannot process 'SerializationException's directly; please consider configuring an 'ErrorHandlingDeserializer' in the value and/or key deserializer", thrownException);
        }
        throw new IllegalStateException("This error handler cannot process '" + thrownException.getClass().getName() + "'s; no record information is available", thrownException);
    }
}

