/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.support.serializer.FailedDeserializationInfo;
import org.springframework.kafka.support.serializer.SerializationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ErrorHandlingDeserializer<T>
implements Deserializer<T> {
    @Deprecated
    public static final String KEY_DESERIALIZER_EXCEPTION_HEADER_PREFIX = "springDeserializerException";
    @Deprecated
    public static final String KEY_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionKey";
    @Deprecated
    public static final String VALUE_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionValue";
    public static final String KEY_FUNCTION = "spring.deserializer.key.function";
    public static final String VALUE_FUNCTION = "spring.deserializer.value.function";
    public static final String KEY_DESERIALIZER_CLASS = "spring.deserializer.key.delegate.class";
    public static final String VALUE_DESERIALIZER_CLASS = "spring.deserializer.value.delegate.class";
    private Deserializer<T> delegate;
    private boolean isForKey;
    private Function<FailedDeserializationInfo, T> failedDeserializationFunction;

    public ErrorHandlingDeserializer() {
    }

    public ErrorHandlingDeserializer(Deserializer<T> delegate) {
        this.delegate = this.setupDelegate(delegate);
    }

    public void setFailedDeserializationFunction(Function<FailedDeserializationInfo, T> failedDeserializationFunction) {
        this.failedDeserializationFunction = failedDeserializationFunction;
    }

    public boolean isForKey() {
        return this.isForKey;
    }

    public void setForKey(boolean isKey) {
        this.isForKey = isKey;
    }

    public ErrorHandlingDeserializer<T> keyDeserializer(boolean isKey) {
        this.isForKey = isKey;
        return this;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.delegate == null) {
            this.setupDelegate(configs, isKey ? KEY_DESERIALIZER_CLASS : VALUE_DESERIALIZER_CLASS);
        }
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"No delegate deserializer configured");
        this.delegate.configure(configs, isKey);
        this.isForKey = isKey;
        if (this.failedDeserializationFunction == null) {
            this.setupFunction(configs, isKey ? KEY_FUNCTION : VALUE_FUNCTION);
        }
    }

    public void setupDelegate(Map<String, ?> configs, String configKey) {
        if (configs.containsKey(configKey)) {
            try {
                Object value = configs.get(configKey);
                Class clazz = value instanceof Class ? (Class)value : ClassUtils.forName((String)((String)value), null);
                this.delegate = this.setupDelegate(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private Deserializer<T> setupDelegate(Object delegate) {
        Assert.isInstanceOf(Deserializer.class, (Object)delegate, (String)"'delegate' must be a 'Deserializer', not a ");
        return (Deserializer)delegate;
    }

    private void setupFunction(Map<String, ?> configs, String configKey) {
        if (configs.containsKey(configKey)) {
            try {
                Object value = configs.get(configKey);
                Class clazz = value instanceof Class ? (Class)value : ClassUtils.forName((String)((String)value), null);
                Assert.isTrue((boolean)Function.class.isAssignableFrom(clazz), (String)("'function' must be a 'Function ', not a " + clazz.getName()));
                this.failedDeserializationFunction = (Function)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public T deserialize(String topic, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, data);
        }
        catch (Exception e) {
            return this.recoverFromSupplier(topic, null, data, e);
        }
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        try {
            if (this.isForKey) {
                headers.remove(KEY_DESERIALIZER_EXCEPTION_HEADER);
            } else {
                headers.remove(VALUE_DESERIALIZER_EXCEPTION_HEADER);
            }
            return (T)this.delegate.deserialize(topic, headers, data);
        }
        catch (Exception e) {
            SerializationUtils.deserializationException(headers, data, e, this.isForKey);
            return this.recoverFromSupplier(topic, headers, data, e);
        }
    }

    private T recoverFromSupplier(String topic, Headers headers, byte[] data, Exception exception) {
        if (this.failedDeserializationFunction != null) {
            FailedDeserializationInfo failedDeserializationInfo = new FailedDeserializationInfo(topic, headers, data, this.isForKey, exception);
            return this.failedDeserializationFunction.apply(failedDeserializationInfo);
        }
        return null;
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

