/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.DeliveryAttemptAware;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.FailedRecordTracker;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.listener.RecoveryStrategy;
import org.springframework.kafka.listener.RetryListener;
import org.springframework.kafka.listener.SeekUtils;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;

public abstract class FailedRecordProcessor
extends ExceptionClassifier
implements DeliveryAttemptAware {
    private static final BiPredicate<ConsumerRecord<?, ?>, Exception> ALWAYS_SKIP_PREDICATE = (r, e) -> true;
    private static final BiPredicate<ConsumerRecord<?, ?>, Exception> NEVER_SKIP_PREDICATE = (r, e) -> false;
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final FailedRecordTracker failureTracker;
    private final List<RetryListener> retryListeners = new ArrayList<RetryListener>();
    private boolean commitRecovered;

    protected FailedRecordProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        this.failureTracker = new FailedRecordTracker(recoverer, backOff, this.logger);
    }

    protected boolean isCommitRecovered() {
        return this.commitRecovered;
    }

    public void setCommitRecovered(boolean commitRecovered) {
        this.commitRecovered = commitRecovered;
    }

    public void setBackOffFunction(BiFunction<ConsumerRecord<?, ?>, Exception, BackOff> backOffFunction) {
        this.failureTracker.setBackOffFunction(backOffFunction);
    }

    public void setResetStateOnRecoveryFailure(boolean resetStateOnRecoveryFailure) {
        this.failureTracker.setResetStateOnRecoveryFailure(resetStateOnRecoveryFailure);
    }

    public void setResetStateOnExceptionChange(boolean resetStateOnExceptionChange) {
        this.failureTracker.setResetStateOnExceptionChange(resetStateOnExceptionChange);
    }

    public void setRetryListeners(RetryListener ... listeners) {
        Assert.noNullElements((Object[])listeners, (String)"'listeners' cannot have null elements");
        this.failureTracker.setRetryListeners(listeners);
        this.retryListeners.clear();
        this.retryListeners.addAll(Arrays.asList(listeners));
    }

    protected List<RetryListener> getRetryListeners() {
        return this.retryListeners;
    }

    @Override
    public int deliveryAttempt(TopicPartitionOffset topicPartitionOffset) {
        return this.failureTracker.deliveryAttempt(topicPartitionOffset);
    }

    @Deprecated
    protected BiPredicate<ConsumerRecord<?, ?>, Exception> getSkipPredicate(List<ConsumerRecord<?, ?>> records, Exception thrownException) {
        if (this.getClassifier().classify((Throwable)thrownException).booleanValue()) {
            return this.failureTracker::skip;
        }
        try {
            this.failureTracker.getRecoverer().accept(records.get(0), thrownException);
        }
        catch (Exception ex) {
            if (records.size() > 0) {
                this.logger.error((Throwable)ex, () -> "Recovery of record (" + ListenerUtils.recordToString((ConsumerRecord)records.get(0)) + ") failed");
            }
            return NEVER_SKIP_PREDICATE;
        }
        return ALWAYS_SKIP_PREDICATE;
    }

    protected RecoveryStrategy getRecoveryStrategy(List<ConsumerRecord<?, ?>> records, Exception thrownException) {
        return this.getRecoveryStrategy(records, null, thrownException);
    }

    protected RecoveryStrategy getRecoveryStrategy(List<ConsumerRecord<?, ?>> records, @Nullable Consumer<?, ?> recoveryConsumer, Exception thrownException) {
        if (this.getClassifier().classify((Throwable)thrownException).booleanValue()) {
            return this.failureTracker::recovered;
        }
        try {
            this.failureTracker.getRecoverer().accept(records.get(0), recoveryConsumer, thrownException);
            this.failureTracker.getRetryListeners().forEach(rl -> rl.recovered((ConsumerRecord)records.get(0), thrownException));
        }
        catch (Exception ex) {
            if (records.size() > 0) {
                if (SeekUtils.isBackoffException(ex)) {
                    this.logger.debug((CharSequence)("Recovery of record (" + ListenerUtils.recordToString(records.get(0)) + ") backed off: " + ex.getMessage()));
                } else {
                    this.logger.error((Throwable)ex, () -> "Recovery of record (" + ListenerUtils.recordToString((ConsumerRecord)records.get(0)) + ") failed");
                }
                this.failureTracker.getRetryListeners().forEach(rl -> rl.recoveryFailed((ConsumerRecord)records.get(0), thrownException, ex));
            }
            return (rec, excep, cont, consumer) -> NEVER_SKIP_PREDICATE.test(rec, excep);
        }
        return (rec, excep, cont, consumer) -> ALWAYS_SKIP_PREDICATE.test(rec, excep);
    }

    public void clearThreadState() {
        this.failureTracker.clearThreadState();
    }
}

